/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table;

import java.util.Date;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ui.ICellFont;
import org.openl.rules.table.ui.ICellStyle;

class GridTableCell
implements ICell {
    private int column;
    private int row;
    private IGridTable table;
    private ICell cell;

    public GridTableCell(int column, int row, IGridTable table) {
        this.column = column;
        this.row = row;
        this.table = table;
        this.cell = table.getGrid().getCell(table.getGridColumn(column, row), table.getGridRow(column, row));
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public int getAbsoluteColumn() {
        return this.cell.getAbsoluteColumn();
    }

    public int getAbsoluteRow() {
        return this.cell.getAbsoluteRow();
    }

    public IGridRegion getAbsoluteRegion() {
        return this.cell.getAbsoluteRegion();
    }

    public IGridRegion getRegion() {
        return this.cell.getRegion();
    }

    public ICellStyle getStyle() {
        return this.cell.getStyle();
    }

    public ICellFont getFont() {
        return this.cell.getFont();
    }

    public int getHeight() {
        return this.table.isNormalOrientation() ? this.cell.getHeight() : this.cell.getWidth();
    }

    public Object getObjectValue() {
        return this.cell.getObjectValue();
    }

    public String getStringValue() {
        return this.cell.getStringValue();
    }

    public int getWidth() {
        return this.table.isNormalOrientation() ? this.cell.getWidth() : this.cell.getHeight();
    }

    public String getFormula() {
        return this.cell.getFormula();
    }

    public int getType() {
        return this.cell.getType();
    }

    public String getUri() {
        return this.cell.getUri();
    }

    public boolean getNativeBoolean() {
        return this.cell.getNativeBoolean();
    }

    public double getNativeNumber() {
        return this.cell.getNativeNumber();
    }

    public int getNativeType() {
        return this.cell.getNativeType();
    }

    public boolean hasNativeType() {
        return this.cell.hasNativeType();
    }

    public Date getNativeDate() {
        return this.cell.getNativeDate();
    }

    public CellMetaInfo getMetaInfo() {
        return this.cell.getMetaInfo();
    }
}

