/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openl.rules.lang.xls.XlsWorkbookSourceCodeModule;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.table.CellKey;
import org.openl.rules.table.GridRegion;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGrid;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.actions.AUndoableCellAction;
import org.openl.rules.table.actions.GridRegionAction;
import org.openl.rules.table.actions.IUndoableGridTableAction;
import org.openl.rules.table.actions.MergeCellsAction;
import org.openl.rules.table.actions.UndoableClearAction;
import org.openl.rules.table.actions.UndoableCompositeAction;
import org.openl.rules.table.actions.UndoableCopyValueAction;
import org.openl.rules.table.actions.UndoableResizeMergedRegionAction;
import org.openl.rules.table.actions.UndoableSetStyleAction;
import org.openl.rules.table.actions.UndoableSetValueAction;
import org.openl.rules.table.actions.UndoableShiftValueAction;
import org.openl.rules.table.actions.UnmergeByColumnsAction;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.rules.table.ui.ICellStyle;
import org.openl.rules.table.xls.XlsSheetGridExporter;
import org.openl.rules.table.xls.XlsSheetGridHelper;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.rules.table.xls.formatters.AXlsFormatter;
import org.openl.rules.table.xls.formatters.XlsFormattersManager;
import org.openl.util.export.IExporter;
import org.openl.util.formatters.IFormatter;

public interface IWritableGrid
extends IGrid {
    public int addMergedRegion(IGridRegion var1);

    public void clearCell(int var1, int var2);

    public void createCell(int var1, int var2, Object var3, String var4, ICellStyle var5);

    public void copyCell(int var1, int var2, int var3, int var4);

    public IGridRegion findEmptyRect(int var1, int var2);

    public void removeMergedRegion(IGridRegion var1);

    public void setCellMetaInfo(int var1, int var2, CellMetaInfo var3);

    public void setCellStyle(int var1, int var2, ICellStyle var3);

    public void setCellValue(int var1, int var2, Object var3);

    public void setCellFormula(int var1, int var2, String var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Tool {
        private static final String PROPERTIES_SECTION_NAME = "properties";
        static final boolean COLUMNS = true;
        static final boolean ROWS = false;
        static final boolean INSERT = true;
        static final boolean REMOVE = false;

        @Deprecated
        public static IExporter createExporter(IWritableGrid wGrid) {
            if (wGrid instanceof XlsSheetGridModel) {
                return new XlsSheetGridExporter((XlsSheetGridModel)wGrid);
            }
            return null;
        }

        @Deprecated
        public static IExporter createExporter(XlsWorkbookSourceCodeModule workbookModule) {
            return XlsSheetGridHelper.createExporter(workbookModule);
        }

        public static IWritableGrid getWritableGrid(IGrid grid) {
            if (grid instanceof IWritableGrid) {
                return (IWritableGrid)grid;
            }
            return null;
        }

        public static IWritableGrid getWritableGrid(IGridTable table) {
            IGrid grid = table.getGrid();
            if (grid instanceof IWritableGrid) {
                return (IWritableGrid)grid;
            }
            return null;
        }

        public static List<IUndoableGridTableAction> resizeMergedRegions(IGridTable table, int firstRowOrColumn, int numberOfRowsOrColumns, boolean isInsert, boolean isColumns, IGridRegion regionOfTable) {
            IWritableGrid grid = (IWritableGrid)table.getGrid();
            ArrayList<IUndoableGridTableAction> resizeActions = new ArrayList<IUndoableGridTableAction>();
            for (int i = 0; i < grid.getNumberOfMergedRegions(); ++i) {
                IGridRegion existingMergedRegion = grid.getMergedRegion(i);
                if (!IGridRegion.Tool.contains(regionOfTable, existingMergedRegion.getLeft(), existingMergedRegion.getTop()) || !Tool.isRegionMustBeResized(existingMergedRegion, firstRowOrColumn, numberOfRowsOrColumns, isColumns, regionOfTable)) continue;
                resizeActions.add(new UndoableResizeMergedRegionAction(existingMergedRegion, numberOfRowsOrColumns, isInsert, isColumns));
            }
            return resizeActions;
        }

        private static boolean isRegionMustBeResized(IGridRegion region, int firstRowOrColumn, int numberOfRowsOrColumns, boolean isColumns, IGridRegion regionOfTable) {
            if (isColumns) {
                return IGridRegion.Tool.width(region) > numberOfRowsOrColumns && IGridRegion.Tool.contains(region, regionOfTable.getLeft() + firstRowOrColumn, region.getTop());
            }
            return IGridRegion.Tool.height(region) > numberOfRowsOrColumns && IGridRegion.Tool.contains(region, region.getLeft(), regionOfTable.getTop() + firstRowOrColumn);
        }

        public static IUndoableGridTableAction insertColumns(int nColumns, int beforeColumns, IGridRegion region, IGridTable table) {
            int h = IGridRegion.Tool.height(region);
            int w = IGridRegion.Tool.width(region);
            int columnsToMove = w - beforeColumns;
            ArrayList<IUndoableGridTableAction> actions = new ArrayList<IUndoableGridTableAction>(h * columnsToMove);
            int firstToMove = region.getLeft() + beforeColumns;
            actions.addAll(Tool.shiftColumns(firstToMove + nColumns, nColumns, true, region, table));
            for (int colFromCopy = firstToMove + nColumns - 1; colFromCopy >= firstToMove; --colFromCopy) {
                for (int row = region.getBottom(); row >= region.getTop(); --row) {
                    AUndoableCellAction action = Tool.copyCell(colFromCopy, row, colFromCopy + nColumns, row, table);
                    if (action == null) continue;
                    actions.add(action);
                }
            }
            actions.addAll(Tool.resizeMergedRegions(table, beforeColumns, nColumns, true, true, region));
            return new UndoableCompositeAction(actions);
        }

        public static IUndoableGridTableAction insertRows(int nRows, int beforeRow, IGridRegion region, IGridTable table) {
            int h = IGridRegion.Tool.height(region);
            int w = IGridRegion.Tool.width(region);
            int rowsToMove = h - beforeRow;
            ArrayList<IUndoableGridTableAction> actions = new ArrayList<IUndoableGridTableAction>(w * rowsToMove);
            int firstToMove = region.getTop() + beforeRow;
            actions.addAll(Tool.shiftRows(firstToMove + nRows, nRows, true, region, table));
            for (int rowFromCopy = firstToMove + nRows - 1; rowFromCopy >= firstToMove; --rowFromCopy) {
                for (int column = region.getRight(); column >= region.getLeft(); --column) {
                    AUndoableCellAction action = Tool.copyCell(column, rowFromCopy, column, rowFromCopy + nRows, table);
                    if (action == null) continue;
                    actions.add(action);
                }
            }
            actions.addAll(Tool.resizeMergedRegions(table, beforeRow, nRows, true, false, region));
            return new UndoableCompositeAction(actions);
        }

        public static CellKey getPropertyCoordinates(IGridRegion region, IGridTable table, String propName) {
            int top;
            int left;
            IWritableGrid grid = (IWritableGrid)table.getGrid();
            ICell propsHeaderCell = grid.getCell(left = region.getLeft(), (top = region.getTop()) + 1);
            String propsHeader = propsHeaderCell.getStringValue();
            if (propsHeader == null || !propsHeader.equals(PROPERTIES_SECTION_NAME)) {
                return null;
            }
            int propsCount = propsHeaderCell.getHeight();
            for (int i = 0; i < propsCount; ++i) {
                ICell propNameCell = grid.getCell(left + propsHeaderCell.getWidth(), top + 1 + i);
                String pName = propNameCell.getStringValue();
                if (pName == null || !pName.equals(propName)) continue;
                return new CellKey(1, 1 + i);
            }
            return null;
        }

        public static IUndoableGridTableAction insertProp(IGridRegion tableRegion, IGridTable table, String newPropName, String newPropValue) {
            if (StringUtils.isBlank((String)newPropValue)) {
                return null;
            }
            int propertyRowIndex = Tool.getPropertyRowIndex(tableRegion, table, newPropName);
            if (propertyRowIndex > 0) {
                return Tool.setExistingPropertyValue(tableRegion, table, newPropName, newPropValue, propertyRowIndex);
            }
            return Tool.insertNewProperty(tableRegion, table, newPropName, newPropValue);
        }

        private static int getPropertyRowIndex(IGridRegion tableRegion, IGridTable table, String newPropName) {
            int topCell;
            int leftCell;
            IWritableGrid grid = (IWritableGrid)table.getGrid();
            String propsHeader = grid.getCell(leftCell = tableRegion.getLeft(), (topCell = tableRegion.getTop()) + 1).getStringValue();
            if (!Tool.tableContainsPropertySection(propsHeader)) {
                return -1;
            }
            int propsCount = grid.getCell(leftCell, topCell + 1).getHeight();
            int propNameCellOffset = grid.getCell(leftCell, topCell + 1).getWidth();
            for (int i = 0; i < propsCount; ++i) {
                String propNameFromTable = grid.getCell(leftCell + propNameCellOffset, topCell + 1 + i).getStringValue();
                if (propNameFromTable == null || !propNameFromTable.equals(newPropName)) continue;
                return topCell + 1 + i;
            }
            return -1;
        }

        private static IUndoableGridTableAction setExistingPropertyValue(IGridRegion tableRegion, IGridTable table, String newPropName, String newPropValue, int propertyRowIndex) {
            int topCell;
            int propNameCellOffset;
            int propValueCellOffset;
            int leftCell;
            IWritableGrid grid = (IWritableGrid)table.getGrid();
            String propValueFromTable = grid.getCell((leftCell = tableRegion.getLeft()) + (propValueCellOffset = (propNameCellOffset = grid.getCell(leftCell, (topCell = tableRegion.getTop()) + 1).getWidth()) + grid.getCell(leftCell + propNameCellOffset, topCell + 1).getWidth()), propertyRowIndex).getStringValue();
            if (propValueFromTable != null && newPropValue != null && propValueFromTable.trim().equals(newPropValue.trim())) {
                return null;
            }
            IFormatter format = Tool.getFormat(newPropName);
            return new UndoableSetValueAction(leftCell + propValueCellOffset, propertyRowIndex, newPropValue, format);
        }

        private static IUndoableGridTableAction insertNewProperty(IGridRegion tableRegion, IGridTable table, String newPropName, String newPropValue) {
            int propValueCellOffset;
            int propNameCellOffset;
            IWritableGrid grid = (IWritableGrid)table.getGrid();
            IFormatter format = Tool.getFormat(newPropName);
            int leftCell = tableRegion.getLeft();
            int topCell = tableRegion.getTop();
            int firstPropertyRow = IGridRegion.Tool.height(grid.getCell(leftCell, topCell).getAbsoluteRegion());
            int rowsToMove = IGridRegion.Tool.height(tableRegion) - firstPropertyRow;
            ArrayList<IUndoableGridTableAction> actions = new ArrayList<IUndoableGridTableAction>(IGridRegion.Tool.width(tableRegion) * rowsToMove);
            String propsHeader = grid.getCell(leftCell, topCell + 1).getStringValue();
            if (!Tool.tableContainsPropertySection(propsHeader)) {
                actions.addAll(Tool.shiftRows(tableRegion.getTop() + firstPropertyRow, 1, true, tableRegion, table));
                actions.add(Tool.createPropertiesSection(tableRegion, table));
                propNameCellOffset = 1;
                propValueCellOffset = 2;
            } else {
                actions.add(Tool.insertRows(1, firstPropertyRow, tableRegion, table));
                actions.add(Tool.resizePropertiesHeader(tableRegion, table));
                propNameCellOffset = grid.getCell(leftCell, topCell + 1).getWidth();
                propValueCellOffset = propNameCellOffset + grid.getCell(leftCell + propNameCellOffset, topCell + 1).getWidth();
            }
            actions.add(new UndoableSetValueAction(leftCell + propNameCellOffset, topCell + firstPropertyRow, newPropName, null));
            actions.add(new UndoableSetValueAction(leftCell + propValueCellOffset, topCell + firstPropertyRow, newPropValue, format));
            return new UndoableCompositeAction(actions);
        }

        private static IUndoableGridTableAction createPropertiesSection(IGridRegion tableRegion, IGridTable table) {
            IWritableGrid grid = (IWritableGrid)table.getGrid();
            int regionWidth = IGridRegion.Tool.width(tableRegion);
            int leftCell = tableRegion.getLeft();
            int topCell = tableRegion.getTop();
            IGridRegion headerRegion = grid.getCell(leftCell, topCell).getAbsoluteRegion();
            ArrayList<IUndoableGridTableAction> actions = new ArrayList<IUndoableGridTableAction>();
            actions.add(new UnmergeByColumnsAction(new GridRegion(headerRegion.getBottom() + 1, leftCell, headerRegion.getBottom() + 1, tableRegion.getRight())));
            actions.add(new UndoableSetValueAction(leftCell, headerRegion.getBottom() + 1, PROPERTIES_SECTION_NAME, null));
            if (regionWidth > 3) {
                for (int j = leftCell + 3; j < leftCell + regionWidth; ++j) {
                    actions.add(new UndoableClearAction(j, headerRegion.getBottom() + 1));
                }
            } else if (regionWidth < 3) {
                actions.add(new MergeCellsAction(new GridRegion(topCell, leftCell, headerRegion.getBottom(), leftCell + 2)));
                int row = headerRegion.getBottom() + 1;
                while (row < tableRegion.getBottom()) {
                    IGridRegion cellToExpandRegion = grid.getCell(leftCell + regionWidth - 1, row).getAbsoluteRegion();
                    actions.add(new MergeCellsAction(new GridRegion(row + 1, cellToExpandRegion.getLeft(), cellToExpandRegion.getBottom() + 1, leftCell + 2)));
                    row = cellToExpandRegion.getBottom() + 1;
                }
                actions.add(new GridRegionAction(tableRegion, true, true, GridRegionAction.ActionType.EXPAND, 3 - regionWidth));
            }
            return new UndoableCompositeAction(actions);
        }

        private static IUndoableGridTableAction resizePropertiesHeader(IGridRegion tableRegion, IGridTable table) {
            int topCell;
            IWritableGrid grid = (IWritableGrid)table.getGrid();
            int firstPropertyRow = 1;
            int leftCell = tableRegion.getLeft();
            int propsCount = grid.getCell(leftCell, (topCell = tableRegion.getTop()) + 1).getHeight();
            if (propsCount == 1) {
                IGridRegion propHeaderRegion = grid.getRegionContaining(leftCell, topCell + 1);
                if (propHeaderRegion == null) {
                    propHeaderRegion = new GridRegion(topCell + 1, leftCell, topCell + 1, leftCell);
                }
                return new UndoableResizeMergedRegionAction(propHeaderRegion, 1, true, false);
            }
            return new UndoableCompositeAction(Tool.resizeMergedRegions(table, firstPropertyRow, 1, true, false, tableRegion));
        }

        private static boolean tableContainsPropertySection(String propsHeader) {
            boolean containsPropSection = false;
            if (propsHeader != null && propsHeader.equals(PROPERTIES_SECTION_NAME)) {
                containsPropSection = true;
            }
            return containsPropSection;
        }

        private static IFormatter getFormat(String propertyName) {
            AXlsFormatter result = null;
            TablePropertyDefinition tablePropeprtyDefinition = TablePropertyDefinitionUtils.getPropertyByName(propertyName);
            if (tablePropeprtyDefinition != null) {
                Class type = tablePropeprtyDefinition.getType().getInstanceClass();
                result = XlsFormattersManager.getFormatter(type, tablePropeprtyDefinition.getFormat());
            }
            return result;
        }

        public static void putCellMetaInfo(IGridTable table, int col, int row, CellMetaInfo meta) {
            IWritableGrid wgrid = Tool.getWritableGrid(table);
            if (wgrid == null) {
                return;
            }
            int gcol = table.getGridColumn(col, row);
            int grow = table.getGridRow(col, row);
            wgrid.setCellMetaInfo(gcol, grow, meta);
        }

        private static List<IUndoableGridTableAction> clearCells(int startColumn, int nCols, int startRow, int nRows, IGrid grid) {
            ArrayList<IUndoableGridTableAction> clearActions = new ArrayList<IUndoableGridTableAction>();
            for (int i = startColumn; i < startColumn + nCols; ++i) {
                for (int j = startRow; j < startRow + nRows; ++j) {
                    if (grid.isPartOfTheMergedRegion(i, j) && !grid.isTopLeftCellInMergedRegion(i, j)) continue;
                    clearActions.add(new UndoableClearAction(i, j));
                }
            }
            return clearActions;
        }

        private static AUndoableCellAction shiftCell(int colFrom, int rowFrom, int colTo, int rowTo, IGridTable table) {
            IGrid grid = table.getGrid();
            if (!grid.isPartOfTheMergedRegion(colFrom, rowFrom) || grid.isTopLeftCellInMergedRegion(colFrom, rowFrom)) {
                return new UndoableShiftValueAction(colFrom, rowFrom, colTo, rowTo);
            }
            return null;
        }

        private static AUndoableCellAction copyCell(int colFrom, int rowFrom, int colTo, int rowTo, IGridTable table) {
            IWritableGrid grid = (IWritableGrid)table.getGrid();
            if (!grid.isInOneMergedRegion(colFrom, rowFrom, colTo, rowTo)) {
                return new UndoableCopyValueAction(colFrom, rowFrom, colTo, rowTo);
            }
            return null;
        }

        private static List<IUndoableGridTableAction> shiftColumns(int startColumn, int nCols, boolean isInsert, IGridRegion region, IGridTable table) {
            int colFromCopy;
            int direction;
            ArrayList<IUndoableGridTableAction> shiftActions = new ArrayList<IUndoableGridTableAction>();
            if (isInsert) {
                direction = -1;
                colFromCopy = region.getRight();
            } else {
                direction = 1;
                colFromCopy = startColumn;
            }
            IGrid grid = table.getGrid();
            if (isInsert) {
                shiftActions.addAll(Tool.clearCells(region.getRight() + 1, nCols, region.getTop(), IGridRegion.Tool.height(region), grid));
            } else {
                for (int column = startColumn - nCols; column < startColumn; ++column) {
                    for (int row = region.getTop(); row <= region.getBottom(); ++row) {
                        if (grid.isPartOfTheMergedRegion(column, row) && (!grid.isTopLeftCellInMergedRegion(column, row) || IGridRegion.Tool.width(grid.getRegionStartingAt(column, row)) > nCols)) continue;
                        shiftActions.add(new UndoableClearAction(column, row));
                    }
                }
            }
            int numColumnsToBeShifted = region.getRight() - startColumn;
            for (int i = 0; i <= numColumnsToBeShifted; ++i) {
                int colToCopy = colFromCopy - direction * nCols;
                for (int row = region.getBottom(); row >= region.getTop(); --row) {
                    AUndoableCellAction action = Tool.shiftCell(colFromCopy, row, colToCopy, row, table);
                    if (action == null) continue;
                    shiftActions.add(action);
                }
                colFromCopy += direction;
            }
            return shiftActions;
        }

        private static List<IUndoableGridTableAction> shiftRows(int startRow, int nRows, boolean isInsert, IGridRegion region, IGridTable table) {
            int rowFromCopy;
            int direction;
            ArrayList<IUndoableGridTableAction> shiftActions = new ArrayList<IUndoableGridTableAction>();
            if (isInsert) {
                direction = -1;
                rowFromCopy = region.getBottom();
            } else {
                direction = 1;
                rowFromCopy = startRow;
            }
            IGrid grid = table.getGrid();
            if (isInsert) {
                shiftActions.addAll(Tool.clearCells(region.getLeft(), IGridRegion.Tool.width(region), region.getBottom() + 1, nRows, grid));
            } else {
                for (int row = startRow - nRows; row < startRow; ++row) {
                    for (int column = region.getLeft(); column <= region.getRight(); ++column) {
                        if (grid.isPartOfTheMergedRegion(column, row) && (!grid.isTopLeftCellInMergedRegion(column, row) || IGridRegion.Tool.height(grid.getRegionStartingAt(column, row)) > nRows)) continue;
                        shiftActions.add(new UndoableClearAction(column, row));
                    }
                }
            }
            int numRowsToBeShifted = region.getBottom() - startRow;
            for (int i = 0; i <= numRowsToBeShifted; ++i) {
                int rowToCopy = rowFromCopy - direction * nRows;
                for (int column = region.getRight(); column >= region.getLeft(); --column) {
                    AUndoableCellAction action = Tool.shiftCell(column, rowFromCopy, column, rowToCopy, table);
                    if (action == null) continue;
                    shiftActions.add(action);
                }
                rowFromCopy += direction;
            }
            return shiftActions;
        }

        public static IUndoableGridTableAction removeColumns(int nCols, int startColumn, IGridRegion region, IGridTable table) {
            int firstToMove = region.getLeft() + startColumn + nCols;
            int w = IGridRegion.Tool.width(region);
            int h = IGridRegion.Tool.height(region);
            ArrayList<IUndoableGridTableAction> actions = new ArrayList<IUndoableGridTableAction>(h * (w - startColumn));
            actions.addAll(Tool.resizeMergedRegions(table, startColumn, nCols, false, true, region));
            actions.addAll(Tool.shiftColumns(firstToMove, nCols, false, region, table));
            actions.addAll(Tool.clearCells(region.getRight() + 1 - nCols, nCols, region.getTop(), h, table.getGrid()));
            return new UndoableCompositeAction(actions);
        }

        public static IUndoableGridTableAction removeRows(int nRows, int startRow, IGridRegion region, IGridTable table) {
            int w = IGridRegion.Tool.width(region);
            int h = IGridRegion.Tool.height(region);
            int firstToMove = region.getTop() + startRow + nRows;
            ArrayList<IUndoableGridTableAction> actions = new ArrayList<IUndoableGridTableAction>(w * (h - startRow));
            actions.addAll(Tool.resizeMergedRegions(table, startRow, nRows, false, false, region));
            actions.addAll(Tool.shiftRows(firstToMove, nRows, false, region, table));
            actions.addAll(Tool.clearCells(region.getLeft(), w, region.getBottom() + 1 - nRows, nRows, table.getGrid()));
            return new UndoableCompositeAction(actions);
        }

        public static IUndoableGridTableAction setStringValue(int col, int row, IGridRegion region, String value, IFormatter format) {
            int gcol = region.getLeft() + col;
            int grow = region.getTop() + row;
            return new UndoableSetValueAction(gcol, grow, value, format);
        }

        public static IUndoableGridTableAction setStringValue(int col, int row, IGridTable table, String value, IFormatter format) {
            int gcol = table.getGridColumn(col, row);
            int grow = table.getGridRow(col, row);
            return new UndoableSetValueAction(gcol, grow, value, format);
        }

        public static IUndoableGridTableAction setStyle(int col, int row, IGridRegion region, ICellStyle style) {
            int gcol = region.getLeft() + col;
            int grow = region.getTop() + row;
            return new UndoableSetStyleAction(gcol, grow, style);
        }

        public static IUndoableGridTableAction setStyle(int col, int row, IGridTable table, ICellStyle style) {
            int gcol = table.getGridColumn(col, row);
            int grow = table.getGridRow(col, row);
            return new UndoableSetStyleAction(gcol, grow, style);
        }
    }
}

