/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table;

import org.openl.rules.table.ALogicalTable;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.TableException;

public class LogicalTable
extends ALogicalTable {
    private int[] rowOffset;
    private int[] columnOffset;

    public LogicalTable(IGridTable table, int width, int height) {
        super(table);
        this.calculateRowOffsets(height);
        this.calculateColumnOffsets(width);
    }

    public LogicalTable(IGridTable table, int[] columnOffset, int[] rowOffset) {
        super(table);
        if (columnOffset == null) {
            int width = LogicalTableHelper.calcLogicalColumns(table);
            this.calculateColumnOffsets(width);
        } else {
            this.columnOffset = columnOffset;
        }
        if (rowOffset == null) {
            int height = LogicalTableHelper.calcLogicalRows(table);
            this.calculateRowOffsets(height);
        } else {
            this.rowOffset = rowOffset;
        }
    }

    private void calculateRowOffsets(int height) {
        this.rowOffset = new int[height + 1];
        int cellHeight = 0;
        int offset = 0;
        for (int i = 0; i < this.rowOffset.length - 1; ++i) {
            this.rowOffset[i] = offset;
            cellHeight = this.table.getCell(0, offset).getHeight();
            offset += cellHeight;
        }
        this.rowOffset[i] = offset;
    }

    private void calculateColumnOffsets(int width) {
        this.columnOffset = new int[width + 1];
        int cellWidth = 0;
        int offset = 0;
        for (int i = 0; i < this.columnOffset.length - 1; ++i) {
            this.columnOffset[i] = offset;
            cellWidth = this.table.getCell(offset, 0).getWidth();
            offset += cellWidth;
        }
        this.columnOffset[i] = offset;
    }

    public int getWidth() {
        return this.columnOffset.length - 1;
    }

    public int getHeight() {
        return this.rowOffset.length - 1;
    }

    public int findColumnStart(int gridOffset) throws TableException {
        for (int i = 0; i < this.columnOffset.length - 1; ++i) {
            if (this.columnOffset[i] == gridOffset) {
                return i;
            }
            if (this.columnOffset[i] <= gridOffset) continue;
            throw new TableException("gridOffset does not match column start");
        }
        throw new TableException("gridOffset is higher than table's width");
    }

    public int findRowStart(int gridOffset) throws TableException {
        for (int i = 0; i < this.rowOffset.length - 1; ++i) {
            if (this.rowOffset[i] == gridOffset) {
                return i;
            }
            if (this.rowOffset[i] <= gridOffset) continue;
            throw new TableException("gridOffset does not match row start");
        }
        throw new TableException("gridOffset is higher than table's height");
    }

    public int getColumnWidth(int column) {
        return this.columnOffset[column + 1] - this.columnOffset[column];
    }

    public int getRowHeight(int row) {
        return this.rowOffset[row + 1] - this.rowOffset[row];
    }

    public ILogicalTable getSubtable(int column, int row, int width, int height) {
        if (width == 0 || height == 0) {
            return null;
        }
        int startRow = this.rowOffset[row];
        int endRow = this.rowOffset[row + height];
        int startColumn = this.columnOffset[column];
        int endColumn = this.columnOffset[column + width];
        return LogicalTableHelper.logicalTable((IGridTable)this.table.getSubtable(startColumn, startRow, endColumn - startColumn, endRow - startRow));
    }

    public int[] getRowOffset() {
        return this.rowOffset;
    }

    public int[] getColumnOffset() {
        return this.columnOffset;
    }
}

