/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table;

import org.openl.rules.table.AGridTableDecorator;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;

public class SubGridTable
extends AGridTableDecorator {
    private int fromColumn;
    private int fromRow;
    private int width;
    private int height;
    private IGridRegion region;

    public SubGridTable(IGridTable table, int fromColumn, int fromRow, int width, int height) {
        super(table);
        this.fromColumn = fromColumn;
        this.fromRow = fromRow;
        this.width = width;
        this.height = height;
        this.region = super.getRegion();
    }

    public IGridRegion getRegion() {
        return this.region;
    }

    public int getGridColumn(int col, int row) {
        return this.table.getGridColumn(this.fromColumn + col, this.fromRow + row);
    }

    public int getGridRow(int col, int row) {
        return this.table.getGridRow(this.fromColumn + col, this.fromRow + row);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isNormalOrientation() {
        return this.table.isNormalOrientation();
    }

    public IGridTable getSubtable(int column, int row, int width, int height) {
        return (IGridTable)this.table.getSubtable(this.fromColumn + column, this.fromRow + row, width, height);
    }

    public ICell getCell(int column, int row) {
        return this.table.getCell(this.fromColumn + column, this.fromRow + row);
    }
}

