/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table;

import org.openl.rules.table.AGridTableDecorator;
import org.openl.rules.table.CoordinatesTransformer;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.Point;

public class TransformedGridTable
extends AGridTableDecorator {
    private CoordinatesTransformer transformer;

    public TransformedGridTable(IGridTable gridTable, CoordinatesTransformer transformer) {
        super(gridTable);
        this.transformer = transformer;
    }

    public CoordinatesTransformer getTransformer() {
        return this.transformer;
    }

    public ICell getCell(int column, int row) {
        Point point = this.getCoordinates(column, row);
        return this.table.getCell(point.getColumn(), point.getRow());
    }

    public String getUri() {
        return this.table.getGrid().getUri();
    }

    private Point getCoordinates(int col, int row) {
        Point point = this.transformer.calculateCoordinates(col, row);
        return point;
    }

    public int getWidth() {
        return this.transformer.getWidth();
    }

    public int getHeight() {
        return this.transformer.getHeight();
    }

    public int getGridRow(int column, int row) {
        Point point = this.getCoordinates(column, row);
        return this.table.getGridRow(point.getColumn(), point.getRow());
    }

    public int getGridColumn(int column, int row) {
        Point point = this.getCoordinates(column, row);
        return this.table.getGridColumn(point.getColumn(), point.getRow());
    }

    public boolean isNormalOrientation() {
        return this.table.isNormalOrientation();
    }
}

