/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.actions;

import org.openl.rules.table.GridRegion;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.actions.IUndoableGridTableAction;

public class GridRegionAction
implements IUndoableGridTableAction {
    IGridRegion region;
    ActionType actionType;
    boolean isInsert;
    boolean isColumns;
    int nRowsOrColumns;

    public GridRegionAction(IGridRegion region, boolean isColumns, boolean isInsert, ActionType actionType, int nRowsOrColumns) {
        this.region = region;
        this.actionType = actionType;
        this.isColumns = isColumns;
        this.isInsert = isInsert;
        this.nRowsOrColumns = nRowsOrColumns;
    }

    public void doAction(IGridTable table) {
        switch (this.actionType) {
            case EXPAND: {
                this.resizeRegion(this.isInsert, this.isColumns, this.nRowsOrColumns, this.region);
                break;
            }
            case MOVE: {
                this.moveRegion(this.isInsert, this.isColumns, this.nRowsOrColumns, this.region);
            }
        }
    }

    public void undoAction(IGridTable table) {
        switch (this.actionType) {
            case EXPAND: {
                this.resizeRegion(!this.isInsert, this.isColumns, this.nRowsOrColumns, this.region);
                break;
            }
            case MOVE: {
                this.moveRegion(!this.isInsert, this.isColumns, this.nRowsOrColumns, this.region);
            }
        }
    }

    public void resizeRegion(boolean isInsert, boolean isColumns, int rowsOrColumns, IGridRegion r) {
        int inc;
        int n = inc = isInsert ? rowsOrColumns : -rowsOrColumns;
        if (isColumns) {
            ((GridRegion)r).setRight(r.getRight() + inc);
        } else {
            ((GridRegion)r).setBottom(r.getBottom() + inc);
        }
    }

    public void moveRegion(boolean isInsert, boolean isColumns, int rowsOrColumns, IGridRegion r) {
        int inc;
        int n = inc = isInsert ? rowsOrColumns : -rowsOrColumns;
        if (isColumns) {
            ((GridRegion)r).setLeft(r.getLeft() + inc);
            ((GridRegion)r).setRight(r.getRight() + inc);
        } else {
            ((GridRegion)r).setTop(r.getTop() + inc);
            ((GridRegion)r).setBottom(r.getBottom() + inc);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ActionType {
        MOVE,
        EXPAND;

    }
}

