/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.actions;

import org.openl.rules.table.GridRegion;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.actions.AUndoableCellAction;

public class UndoableClearAction
extends AUndoableCellAction {
    private GridRegion toRestore;

    public UndoableClearAction(int col, int row) {
        super(col, row);
    }

    public void doAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        this.savePrevCell(grid);
        grid.clearCell(this.getCol(), this.getRow());
        this.clearRegion(grid);
    }

    public void undoAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        if (this.toRestore != null) {
            grid.addMergedRegion(this.toRestore);
        }
        this.restorePrevCell(grid);
    }

    void clearRegion(IWritableGrid grid) {
        IGridRegion rrTo = grid.getRegionStartingAt(this.getCol(), this.getRow());
        if (rrTo == null) {
            return;
        }
        this.toRestore = new GridRegion(rrTo);
        grid.removeMergedRegion(this.toRestore);
    }
}

