/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.actions;

import java.util.ArrayList;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.actions.GridRegionAction;
import org.openl.rules.table.actions.IUndoableGridTableAction;
import org.openl.rules.table.actions.UndoableCompositeAction;
import org.openl.rules.table.actions.UndoableEditTableAction;

public abstract class UndoableInsertAction
extends UndoableEditTableAction {
    private IUndoableGridTableAction action;

    public void doAction(IGridTable table) {
        IUndoableGridTableAction moveTableAction = null;
        if (!this.canPerformAction(table)) {
            try {
                moveTableAction = UndoableInsertAction.moveTable(table);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int numberToInsert = this.getNumberToInsert(table);
        IGridRegion fullTableRegion = UndoableInsertAction.getOriginalRegion(table);
        ArrayList<IUndoableGridTableAction> actions = new ArrayList<IUndoableGridTableAction>();
        IUndoableGridTableAction ua = this.performAction(numberToInsert, fullTableRegion, table);
        actions.add(ua);
        GridRegionAction allTable = this.getGridRegionAction(fullTableRegion, numberToInsert);
        actions.add(allTable);
        if (UndoableInsertAction.isDecoratorTable(table)) {
            GridRegionAction displayTable = this.getGridRegionAction(table.getRegion(), numberToInsert);
            actions.add(displayTable);
        }
        this.action = new UndoableCompositeAction(actions);
        this.action.doAction(table);
        if (moveTableAction != null) {
            this.action = new UndoableCompositeAction(moveTableAction, this.action);
        }
    }

    public void undoAction(IGridTable table) {
        this.action.undoAction(table);
    }

    protected abstract boolean canPerformAction(IGridTable var1);

    protected abstract int getNumberToInsert(IGridTable var1);

    protected abstract IUndoableGridTableAction performAction(int var1, IGridRegion var2, IGridTable var3);

    protected abstract GridRegionAction getGridRegionAction(IGridRegion var1, int var2);
}

