/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.actions;

import java.util.ArrayList;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.actions.GridRegionAction;
import org.openl.rules.table.actions.IUndoableGridTableAction;
import org.openl.rules.table.actions.UndoableCompositeAction;
import org.openl.rules.table.actions.UndoableEditTableAction;

public abstract class UndoableRemoveAction
extends UndoableEditTableAction {
    private IUndoableGridTableAction action;

    public void doAction(IGridTable table) {
        IGridRegion fullTableRegion = UndoableRemoveAction.getOriginalRegion(table);
        if (!this.canPerformAction(fullTableRegion)) {
            return;
        }
        int numberToRemove = this.getNumberToRemove(table);
        ArrayList<IUndoableGridTableAction> actions = new ArrayList<IUndoableGridTableAction>();
        IUndoableGridTableAction ua = this.performAction(numberToRemove, fullTableRegion, table);
        actions.add(ua);
        GridRegionAction allTable = this.getGridRegionAction(fullTableRegion, numberToRemove);
        actions.add(allTable);
        if (UndoableRemoveAction.isDecoratorTable(table)) {
            GridRegionAction displayTable = this.getGridRegionAction(table.getRegion(), numberToRemove);
            actions.add(displayTable);
        }
        this.action = new UndoableCompositeAction(actions);
        this.action.doAction(table);
    }

    public void undoAction(IGridTable table) {
        this.action.undoAction(table);
    }

    protected abstract boolean canPerformAction(IGridRegion var1);

    protected abstract int getNumberToRemove(IGridTable var1);

    protected abstract IUndoableGridTableAction performAction(int var1, IGridRegion var2, IGridTable var3);

    protected abstract GridRegionAction getGridRegionAction(IGridRegion var1, int var2);
}

