/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.actions;

import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.actions.GridRegionAction;
import org.openl.rules.table.actions.IUndoableGridTableAction;
import org.openl.rules.table.actions.UndoableRemoveAction;

public class UndoableRemoveColumnsAction
extends UndoableRemoveAction {
    private int nCols;
    private int startCol;
    private int row;

    public UndoableRemoveColumnsAction(int nCols, int startCol, int row) {
        this.nCols = nCols;
        this.startCol = startCol;
        this.row = row;
    }

    protected boolean canPerformAction(IGridRegion gridRegion) {
        return this.startCol >= 0 && this.startCol < IGridRegion.Tool.width(gridRegion);
    }

    protected int getNumberToRemove(IGridTable table) {
        int cellWidth = UndoableRemoveColumnsAction.getOriginalTable(table).getCell(this.startCol, this.row).getWidth();
        int numberToInsert = this.nCols;
        if (cellWidth > 1) {
            numberToInsert += cellWidth - 1;
        }
        return numberToInsert;
    }

    protected IUndoableGridTableAction performAction(int numberToRemove, IGridRegion fullTableRegion, IGridTable table) {
        return IWritableGrid.Tool.removeColumns(numberToRemove, this.startCol, fullTableRegion, table);
    }

    protected GridRegionAction getGridRegionAction(IGridRegion gridRegion, int numberToRemove) {
        return new GridRegionAction(gridRegion, true, false, GridRegionAction.ActionType.EXPAND, numberToRemove);
    }
}

