/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.actions;

import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.actions.GridRegionAction;
import org.openl.rules.table.actions.IUndoableGridTableAction;
import org.openl.rules.table.actions.UndoableRemoveAction;

public class UndoableRemoveRowsAction
extends UndoableRemoveAction {
    private int nRows;
    private int startRow;
    private int col;

    public UndoableRemoveRowsAction(int nRows, int startRow, int col) {
        this.nRows = nRows;
        this.startRow = startRow;
        this.col = col;
    }

    protected boolean canPerformAction(IGridRegion gridRegion) {
        return this.startRow >= 0 && this.startRow < IGridRegion.Tool.height(gridRegion);
    }

    protected GridRegionAction getGridRegionAction(IGridRegion gridRegion, int numberToRemove) {
        return new GridRegionAction(gridRegion, false, false, GridRegionAction.ActionType.EXPAND, numberToRemove);
    }

    protected int getNumberToRemove(IGridTable table) {
        int cellHeight = UndoableRemoveRowsAction.getOriginalTable(table).getCell(this.col, this.startRow).getHeight();
        int numberToRemove = this.nRows;
        if (cellHeight > 1) {
            numberToRemove += cellHeight - 1;
        }
        return numberToRemove;
    }

    protected IUndoableGridTableAction performAction(int numberToRemove, IGridRegion fullTableRegion, IGridTable table) {
        return IWritableGrid.Tool.removeRows(numberToRemove, this.startRow, fullTableRegion, table);
    }
}

