/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.actions;

import org.openl.rules.table.GridRegion;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.actions.IUndoableGridTableAction;

public class UndoableResizeMergedRegionAction
implements IUndoableGridTableAction {
    private IGridRegion initialRegion;
    private IGridRegion newRegion;

    public UndoableResizeMergedRegionAction(IGridRegion initialRegion, int numberOfRowsOrColumns, boolean isInsert, boolean isColumns) {
        this.initialRegion = initialRegion;
        int increase = isInsert ? numberOfRowsOrColumns : -numberOfRowsOrColumns;
        try {
            this.newRegion = isColumns ? new GridRegion(initialRegion.getTop(), initialRegion.getLeft(), initialRegion.getBottom(), initialRegion.getRight() + increase) : new GridRegion(initialRegion.getTop(), initialRegion.getLeft(), initialRegion.getBottom() + increase, initialRegion.getRight());
        }
        catch (IllegalArgumentException e) {
            this.newRegion = null;
        }
        if (IGridRegion.Tool.width(this.newRegion) == 1 && IGridRegion.Tool.height(this.newRegion) == 1) {
            this.newRegion = null;
        }
    }

    public void doAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        grid.removeMergedRegion(this.initialRegion);
        if (this.newRegion != null) {
            grid.addMergedRegion(this.newRegion);
        }
    }

    public void undoAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        if (this.newRegion != null) {
            grid.removeMergedRegion(this.newRegion);
        }
        grid.addMergedRegion(this.initialRegion);
    }
}

