/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.actions;

import org.apache.commons.lang.StringUtils;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.actions.AUndoableCellAction;
import org.openl.util.formatters.IFormatter;

public class UndoableSetValueAction
extends AUndoableCellAction {
    private String newValue;
    private IFormatter format;

    public UndoableSetValueAction(int col, int row, String value, IFormatter format) {
        super(col, row);
        this.newValue = value;
        this.format = format;
    }

    public void doAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        ICell cell = grid.getCell(this.getCol(), this.getRow());
        this.setPrevValue(cell.getObjectValue());
        this.setPrevFormula(cell.getFormula());
        Object result = this.newValue;
        if (this.format != null) {
            result = this.format.parse(this.newValue);
        }
        grid.setCellValue(this.getCol(), this.getRow(), result);
    }

    public void undoAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        if (StringUtils.isNotBlank((String)this.getPrevFormula())) {
            grid.setCellFormula(this.getCol(), this.getRow(), this.getPrevFormula());
        } else {
            grid.setCellValue(this.getCol(), this.getRow(), this.getPrevValue());
        }
    }
}

