/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.actions;

import org.openl.rules.table.GridRegion;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.actions.AUndoableCellAction;

public class UndoableShiftValueAction
extends AUndoableCellAction {
    private int colFrom;
    private int rowFrom;
    private IGridRegion toRestore;
    private IGridRegion toRemove;

    public UndoableShiftValueAction(int colFrom, int rowFrom, int colTo, int rowTo) {
        super(colTo, rowTo);
        this.colFrom = colFrom;
        this.rowFrom = rowFrom;
    }

    public void doAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        IGridRegion rrFrom = grid.getRegionStartingAt(this.colFrom, this.rowFrom);
        this.setPrevValue(grid.getCell(this.colFrom, this.rowFrom).getObjectValue());
        this.setPrevFormula(grid.getCell(this.colFrom, this.rowFrom).getFormula());
        this.setPrevStyle(grid.getCell(this.colFrom, this.rowFrom).getStyle());
        if (rrFrom != null) {
            this.toRestore = rrFrom;
            grid.removeMergedRegion(rrFrom);
            GridRegion copyFrom = new GridRegion(rrFrom.getTop() + this.getRow() - this.rowFrom, rrFrom.getLeft() + this.getCol() - this.colFrom, rrFrom.getBottom() + this.getRow() - this.rowFrom, rrFrom.getRight() + this.getCol() - this.colFrom);
            grid.addMergedRegion(copyFrom);
            this.toRemove = copyFrom;
        }
        grid.setCellFormula(this.getCol(), this.getRow(), this.getPrevFormula());
        grid.setCellValue(this.getCol(), this.getRow(), this.getPrevValue());
        grid.setCellStyle(this.getCol(), this.getRow(), this.getPrevStyle());
    }

    public void undoAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        this.setPrevValue(grid.getCell(this.getCol(), this.getRow()).getObjectValue());
        this.setPrevFormula(grid.getCell(this.getCol(), this.getRow()).getFormula());
        this.setPrevStyle(grid.getCell(this.getCol(), this.getRow()).getStyle());
        if (this.toRemove != null) {
            grid.removeMergedRegion(this.toRemove);
            grid.addMergedRegion(this.toRestore);
        }
        grid.setCellFormula(this.colFrom, this.rowFrom, this.getPrevFormula());
        grid.setCellValue(this.colFrom, this.rowFrom, this.getPrevValue());
        grid.setCellStyle(this.colFrom, this.rowFrom, this.getPrevStyle());
    }
}

