/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.openl;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.openl.binding.IBindingContext;
import org.openl.rules.indexer.IDocumentType;
import org.openl.rules.indexer.IIndexElement;
import org.openl.rules.table.IGridTable;
import org.openl.source.IOpenSourceCodeModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridCellSourceCodeModule
implements IOpenSourceCodeModule,
IIndexElement {
    private IGridTable table;
    private String code;
    private int row;
    private int column;
    private String uri;
    private Map<String, Object> params;

    public GridCellSourceCodeModule(IGridTable table) {
        this(table, 0, 0, null);
    }

    public GridCellSourceCodeModule(IGridTable table, IBindingContext bindingContext) {
        this(table, 0, 0, bindingContext);
    }

    public GridCellSourceCodeModule(IGridTable table, int column, int row, IBindingContext bindingContext) {
        this.table = table;
        this.column = column;
        this.row = row;
        if (bindingContext != null && bindingContext.isExecutionMode()) {
            this.getCode();
            this.getUri();
            this.table = null;
        }
    }

    public InputStream getByteStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCategory() {
        return IDocumentType.WORKSHEET_CELL.getCategory();
    }

    public Reader getCharacterStream() {
        return new StringReader(this.getCode());
    }

    public String getCode() {
        if (this.code == null) {
            this.code = this.table.getCell(this.column, this.row).getStringValue();
            if (this.code == null) {
                this.code = "";
            }
        }
        return this.code;
    }

    @Override
    public String getDisplayName() {
        return "Cell";
    }

    @Override
    public String getIndexedText() {
        return this.table.getCell(this.column, this.row).getStringValue();
    }

    public int getStartPosition() {
        return 0;
    }

    public int getTabSize() {
        return 2;
    }

    @Override
    public String getType() {
        return IDocumentType.WORKSHEET_CELL.getCategory();
    }

    @Override
    public String getUri() {
        if (this.uri == null) {
            this.uri = this.table.getUri(this.column, this.row);
        }
        return this.uri;
    }

    public String getUri(int textpos) {
        return this.getUri();
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }
}

