/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.properties;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.BindHelper;
import org.openl.rules.binding.RulesModuleBindingContext;
import org.openl.rules.convertor.IString2DataConvertor;
import org.openl.rules.convertor.String2DataConvertorFactory;
import org.openl.rules.data.DataNodeBinder;
import org.openl.rules.data.ITable;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.PropertiesHelper;
import org.openl.rules.table.properties.TableProperties;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.rules.table.properties.inherit.InheritanceLevel;
import org.openl.rules.table.properties.inherit.PropertiesChecker;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenClass;
import org.openl.types.java.JavaOpenClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesLoader {
    private static final String EXTERNAL_MODULE_PROPERTIES_KEY = "external-module-properties";
    private static final String PROPERTIES_SECTION_NAME = "Properties_Section";
    private OpenL openl;
    private RulesModuleBindingContext cxt;
    private XlsModuleOpenClass module;

    public PropertiesLoader(OpenL openl, RulesModuleBindingContext cxt, XlsModuleOpenClass module) {
        this.openl = openl;
        this.cxt = cxt;
        this.module = module;
    }

    private void loadPropertiesAsDataTable(TableSyntaxNode tableSyntaxNode) throws Exception {
        String propertySectionName = PROPERTIES_SECTION_NAME + tableSyntaxNode.getUri();
        DataNodeBinder dataNodeBinder = new DataNodeBinder();
        ITable propertyTable = this.module.getDataBase().addNewTable(propertySectionName, tableSyntaxNode);
        JavaOpenClass propetiesClass = JavaOpenClass.getOpenClass(TableProperties.class);
        ILogicalTable propertiesSection = PropertiesHelper.getPropertiesTableSection(tableSyntaxNode.getTable());
        if (propertiesSection != null) {
            dataNodeBinder.processTable(this.module, propertyTable, propertiesSection, propertySectionName, (IOpenClass)propetiesClass, (IBindingContext)this.cxt, this.openl, false);
            TableProperties propertiesInstance = ((TableProperties[])propertyTable.getDataArray())[0];
            propertiesInstance.setPropertiesSection(propertiesSection);
            String tableType = tableSyntaxNode.getType();
            Set<String> propertyNamesToCheck = propertiesInstance.getPropertiesDefinedInTable().keySet();
            this.checkProperties(propertyNamesToCheck, tableSyntaxNode);
            propertiesInstance.setCurrentTableType(tableType);
            tableSyntaxNode.setTableProperties(propertiesInstance);
        }
    }

    private void checkProperties(Set<String> propertyNamesToCheck, TableSyntaxNode tableSyntaxNode) {
        this.checkPropertiesLevel(propertyNamesToCheck, tableSyntaxNode);
        this.checkPropertiesForTableType(propertyNamesToCheck, tableSyntaxNode);
    }

    private void checkPropertiesLevel(Set<String> propertyNamesToCheck, TableSyntaxNode tableSyntaxNode) {
        InheritanceLevel currentLevel = InheritanceLevel.TABLE;
        for (String propertyNameToCheck : propertyNamesToCheck) {
            if (PropertiesChecker.isPropertySuitableForLevel(currentLevel, propertyNameToCheck)) continue;
            String message = String.format("Property '%s' can`t be defined on the '%s' level", propertyNameToCheck, currentLevel.getDisplayName());
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)tableSyntaxNode);
            tableSyntaxNode.addError(error);
            BindHelper.processError((SyntaxNodeException)error);
        }
    }

    private void checkPropertiesForTableType(Set<String> propertyNamesToCheck, TableSyntaxNode tableSyntaxNode) {
        String tableType = tableSyntaxNode.getType();
        for (String propertyNameToCheck : propertyNamesToCheck) {
            if (PropertiesChecker.isPropertySuitableForTableType(propertyNameToCheck, tableType)) continue;
            String message = String.format("Property '%s' can`t be defined in table of type '%s'", propertyNameToCheck, tableType);
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)tableSyntaxNode);
            tableSyntaxNode.addError(error);
            BindHelper.processError((SyntaxNodeException)error);
        }
    }

    private void loadCategoryProperties(TableSyntaxNode tableSyntaxNode) {
        ITableProperties tableProperties = tableSyntaxNode.getTableProperties();
        String category = this.getCategory(tableSyntaxNode);
        TableSyntaxNode categoryPropertiesTsn = this.cxt.getTableSyntaxNode(RulesModuleBindingContext.CATEGORY_PROPERTIES_KEY + category);
        if (categoryPropertiesTsn != null) {
            ITableProperties categoryProperties = categoryPropertiesTsn.getTableProperties();
            tableProperties.setPropertiesAppliedForCategory(categoryProperties.getAllProperties());
            tableProperties.setCategoryPropertiesTable(categoryProperties.getPropertiesSection());
        }
    }

    private String getCategory(TableSyntaxNode tsn) {
        ITableProperties tableProperties = tsn.getTableProperties();
        String category = tableProperties.getCategory();
        if (category != null) {
            return category;
        }
        return ((XlsSheetSourceCodeModule)tsn.getModule()).getSheetName();
    }

    private void loadModuleProperties(TableSyntaxNode tableSyntaxNode) {
        ITableProperties tableProperties = tableSyntaxNode.getTableProperties();
        TableSyntaxNode modulePropertiesTsn = this.cxt.getTableSyntaxNode(RulesModuleBindingContext.MODULE_PROPERTIES_KEY);
        if (tableProperties != null && modulePropertiesTsn != null) {
            ITableProperties moduleProperties = modulePropertiesTsn.getTableProperties();
            tableProperties.setPropertiesAppliedForModule(moduleProperties.getAllProperties());
            tableProperties.setModulePropertiesTable(moduleProperties.getPropertiesSection());
        }
    }

    public void loadDefaultProperties(TableSyntaxNode tableSyntaxNode) {
        if (tableSyntaxNode.getTableProperties() == null) {
            this.createTableProperties(tableSyntaxNode);
        }
        ITableProperties properties = tableSyntaxNode.getTableProperties();
        List<TablePropertyDefinition> propertiesWithDefaultValues = TablePropertyDefinitionUtils.getPropertiesToBeSetByDefault();
        HashMap<String, Object> defaultProperties = new HashMap<String, Object>();
        for (TablePropertyDefinition propertyWithDefaultValue : propertiesWithDefaultValues) {
            String defaultPropertyName = propertyWithDefaultValue.getName();
            TablePropertyDefinition propertyDefinition = TablePropertyDefinitionUtils.getPropertyByName(defaultPropertyName);
            Class defaultPropertyValueType = propertyDefinition.getType().getInstanceClass();
            IString2DataConvertor converter = String2DataConvertorFactory.getConvertor(defaultPropertyValueType);
            Object defaultValue = converter.parse(propertyWithDefaultValue.getDefaultValue(), propertyWithDefaultValue.getFormat(), null);
            defaultProperties.put(defaultPropertyName, defaultValue);
        }
        properties.setPropertiesAppliedByDefault(defaultProperties);
    }

    private void createTableProperties(TableSyntaxNode tableSyntaxNode) {
        TableProperties properties = new TableProperties();
        properties.setCurrentTableType(tableSyntaxNode.getType());
        tableSyntaxNode.setTableProperties(properties);
    }

    public void loadProperties(TableSyntaxNode tsn) throws Exception {
        String tableType = tsn.getType();
        if (!XlsNodeTypes.XLS_PROPERTIES.toString().equals(tableType)) {
            try {
                this.loadPropertiesAsDataTable(tsn);
                if (tsn.getTableProperties() == null) {
                    this.createTableProperties(tsn);
                }
            }
            catch (Exception ex) {
                this.createTableProperties(tsn);
                throw ex;
            }
            this.loadExternalProperties(tsn);
            this.loadCategoryProperties(tsn);
            this.loadModuleProperties(tsn);
            this.loadDefaultProperties(tsn);
        }
    }

    private void loadExternalProperties(TableSyntaxNode tsn) {
        Map externalParams = this.cxt.getExternalParams();
        if (externalParams != null && externalParams.get(EXTERNAL_MODULE_PROPERTIES_KEY) != null && externalParams.get(EXTERNAL_MODULE_PROPERTIES_KEY) instanceof ITableProperties) {
            if (tsn.getTableProperties() == null) {
                this.createTableProperties(tsn);
            }
            ITableProperties properties = tsn.getTableProperties();
            ITableProperties externalProperties = (ITableProperties)externalParams.get(EXTERNAL_MODULE_PROPERTIES_KEY);
            properties.setExternalPropertiesAppliedForModule(externalProperties.getAllProperties());
        }
    }
}

