/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.properties;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openl.rules.enumeration.CountriesEnum;
import org.openl.rules.enumeration.CurrenciesEnum;
import org.openl.rules.enumeration.LanguagesEnum;
import org.openl.rules.enumeration.RegionsEnum;
import org.openl.rules.enumeration.UsRegionsEnum;
import org.openl.rules.enumeration.UsStatesEnum;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.rules.table.properties.inherit.InheritanceLevel;
import org.openl.rules.table.properties.inherit.PropertiesChecker;
import org.openl.types.IOpenClass;
import org.openl.types.impl.DynamicObject;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ArrayTool;
import org.openl.util.EnumUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableProperties
extends DynamicObject
implements ITableProperties {
    private String currentTableType;
    private ILogicalTable propertySection;
    private ILogicalTable modulePropertiesTable;
    private ILogicalTable categoryPropertiesTable;
    private Map<String, Object> categoryProperties = new HashMap<String, Object>();
    private Map<String, Object> externalModuleProperties = new HashMap<String, Object>();
    private Map<String, Object> moduleProperties = new HashMap<String, Object>();
    private Map<String, Object> defaultProperties = new HashMap<String, Object>();

    private Map<String, Object> mergeLevelProperties(Map<String, Object> downLevelProperties, Map<String, Object> upLevelProperties) {
        Map<String, Object> resultProperties = downLevelProperties;
        for (Map.Entry<String, Object> upLevelProperty : upLevelProperties.entrySet()) {
            String upLevelPropertyName = upLevelProperty.getKey();
            Object upLevelPropertyValue = upLevelProperty.getValue();
            if (!PropertiesChecker.isPropertySuitableForTableType(upLevelPropertyName, this.currentTableType) || downLevelProperties.containsKey(upLevelPropertyName)) continue;
            resultProperties.put(upLevelPropertyName, upLevelPropertyValue);
        }
        return resultProperties;
    }

    public IOpenClass getType() {
        return JavaOpenClass.getOpenClass(this.getClass());
    }

    public void setType(IOpenClass type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return (String)this.getPropertyValue("name");
    }

    @Override
    public void setName(String name) {
        this.setFieldValue("name", name);
    }

    @Override
    public String getCategory() {
        return (String)this.getPropertyValue("category");
    }

    @Override
    public void setCategory(String category) {
        this.setFieldValue("category", category);
    }

    @Override
    public String getDescription() {
        return (String)this.getPropertyValue("description");
    }

    @Override
    public void setDescription(String description) {
        this.setFieldValue("description", description);
    }

    @Override
    public String[] getTags() {
        return (String[])this.getPropertyValue("tags");
    }

    @Override
    public void setTags(String[] tags) {
        this.setFieldValue("tags", tags);
    }

    @Override
    public Date getEffectiveDate() {
        return (Date)this.getPropertyValue("effectiveDate");
    }

    @Override
    public void setEffectiveDate(Date effectiveDate) {
        this.setFieldValue("effectiveDate", effectiveDate);
    }

    @Override
    public Date getExpirationDate() {
        return (Date)this.getPropertyValue("expirationDate");
    }

    @Override
    public void setExpirationDate(Date expirationDate) {
        this.setFieldValue("expirationDate", expirationDate);
    }

    @Override
    public String getCreatedBy() {
        return (String)this.getPropertyValue("createdBy");
    }

    @Override
    public void setCreatedBy(String createdBy) {
        this.setFieldValue("createdBy", createdBy);
    }

    @Override
    public Date getCreatedOn() {
        return (Date)this.getPropertyValue("createdOn");
    }

    @Override
    public void setCreatedOn(Date createdOn) {
        this.setFieldValue("createdOn", createdOn);
    }

    @Override
    public String getModifiedBy() {
        return (String)this.getPropertyValue("modifiedBy");
    }

    @Override
    public void setModifiedBy(String modifiedBy) {
        this.setFieldValue("modifiedBy", modifiedBy);
    }

    @Override
    public Date getModifiedOn() {
        return (Date)this.getPropertyValue("modifiedOn");
    }

    @Override
    public void setModifiedOn(Date modifiedOn) {
        this.setFieldValue("modifiedOn", modifiedOn);
    }

    @Override
    public String getBuildPhase() {
        return (String)this.getPropertyValue("buildPhase");
    }

    @Override
    public void setBuildPhase(String buildPhase) {
        this.setFieldValue("buildPhase", buildPhase);
    }

    @Override
    public String getValidateDT() {
        return (String)this.getPropertyValue("validateDT");
    }

    @Override
    public void setValidateDT(String validateDT) {
        this.setFieldValue("validateDT", validateDT);
    }

    @Override
    public String getLob() {
        return (String)this.getPropertyValue("lob");
    }

    @Override
    public void setLob(String lob) {
        this.setFieldValue("lob", lob);
    }

    @Override
    public UsRegionsEnum getUsregion() {
        return (UsRegionsEnum)((Object)this.getPropertyValue("usregion"));
    }

    @Override
    public void setUsregion(UsRegionsEnum usregion) {
        this.setFieldValue("usregion", (Object)usregion);
    }

    @Override
    public CountriesEnum[] getCountry() {
        return (CountriesEnum[])this.getPropertyValue("country");
    }

    @Override
    public void setCountry(CountriesEnum[] country) {
        this.setFieldValue("country", country);
    }

    @Override
    public CurrenciesEnum getCurrency() {
        return (CurrenciesEnum)((Object)this.getPropertyValue("currency"));
    }

    @Override
    public void setCurrency(CurrenciesEnum currency) {
        this.setFieldValue("currency", (Object)currency);
    }

    @Override
    public LanguagesEnum getLang() {
        return (LanguagesEnum)((Object)this.getPropertyValue("lang"));
    }

    @Override
    public void setLang(LanguagesEnum lang) {
        this.setFieldValue("lang", (Object)lang);
    }

    @Override
    public UsStatesEnum[] getState() {
        return (UsStatesEnum[])this.getPropertyValue("state");
    }

    @Override
    public void setState(UsStatesEnum[] state) {
        this.setFieldValue("state", state);
    }

    @Override
    public RegionsEnum getRegion() {
        return (RegionsEnum)((Object)this.getPropertyValue("region"));
    }

    @Override
    public void setRegion(RegionsEnum region) {
        this.setFieldValue("region", (Object)region);
    }

    @Override
    public String getVersion() {
        return (String)this.getPropertyValue("version");
    }

    @Override
    public void setVersion(String version) {
        this.setFieldValue("version", version);
    }

    @Override
    public Boolean getActive() {
        return (Boolean)this.getPropertyValue("active");
    }

    @Override
    public void setActive(Boolean active) {
        this.setFieldValue("active", active);
    }

    @Override
    public Boolean getFailOnMiss() {
        return (Boolean)this.getPropertyValue("failOnMiss");
    }

    @Override
    public void setFailOnMiss(Boolean failOnMiss) {
        this.setFieldValue("failOnMiss", failOnMiss);
    }

    @Override
    public String getScope() {
        return (String)this.getPropertyValue("scope");
    }

    @Override
    public void setScope(String scope) {
        this.setFieldValue("scope", scope);
    }

    @Override
    public String getDatatypePackage() {
        return (String)this.getPropertyValue("datatypePackage");
    }

    @Override
    public void setDatatypePackage(String datatypePackage) {
        this.setFieldValue("datatypePackage", datatypePackage);
    }

    @Override
    public Object getPropertyValue(String key) {
        return this.getAllProperties().get(key);
    }

    @Override
    public String getPropertyValueAsString(String key) {
        String result = null;
        Object propValue = this.getPropertyValue(key);
        if (propValue != null) {
            if (propValue instanceof Date) {
                String format = TablePropertyDefinitionUtils.getPropertyByName(key).getFormat();
                if (format != null) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                    result = dateFormat.format((Date)propValue);
                }
            } else if (EnumUtils.isEnum((Object)propValue)) {
                result = ((Enum)propValue).name();
            } else if (EnumUtils.isEnumArray((Object)propValue)) {
                Object[] enums = (Object[])propValue;
                if (!ArrayTool.isEmpty((Object[])enums)) {
                    Object[] names = EnumUtils.getNames((Object[])enums);
                    result = StringUtils.join((Object[])names, (String)",");
                } else {
                    result = "";
                }
            } else {
                result = propValue.toString();
            }
        }
        return result;
    }

    @Override
    public InheritanceLevel getPropertyLevelDefinedOn(String propertyName) {
        InheritanceLevel result = null;
        if (this.getPropertiesDefinedInTable().containsKey(propertyName)) {
            result = InheritanceLevel.TABLE;
        } else if (this.getPropertiesAppliedForCategory().containsKey(propertyName)) {
            result = InheritanceLevel.CATEGORY;
        } else if (this.getPropertiesAppliedForModule().containsKey(propertyName)) {
            result = InheritanceLevel.MODULE;
        }
        return result;
    }

    @Override
    public boolean isPropertyAppliedByDefault(String propertyName) {
        boolean result = false;
        if (this.getPropertyLevelDefinedOn(propertyName) == null && this.defaultProperties.containsKey(propertyName)) {
            result = true;
        }
        return result;
    }

    @Override
    public ILogicalTable getPropertiesSection() {
        return this.propertySection;
    }

    public void setPropertiesSection(ILogicalTable propertySection) {
        this.propertySection = propertySection;
    }

    @Override
    public ILogicalTable getModulePropertiesTable() {
        return this.modulePropertiesTable;
    }

    @Override
    public void setModulePropertiesTable(ILogicalTable modulePropertiesTable) {
        this.modulePropertiesTable = modulePropertiesTable;
    }

    @Override
    public ILogicalTable getCategoryPropertiesTable() {
        return this.categoryPropertiesTable;
    }

    @Override
    public void setCategoryPropertiesTable(ILogicalTable categoryPropertiesTable) {
        this.categoryPropertiesTable = categoryPropertiesTable;
    }

    @Override
    public Map<String, Object> getAllProperties() {
        Map<String, Object> tableAndCategoryProp = this.mergeLevelProperties(super.getFieldValues(), this.categoryProperties);
        Map<String, Object> tableAndCategoryAndModuleProp = this.mergeLevelProperties(tableAndCategoryProp, this.moduleProperties);
        Map<String, Object> tableAndCategoryAndModuleAndExteranlProp = this.mergeLevelProperties(tableAndCategoryAndModuleProp, this.externalModuleProperties);
        return this.mergeLevelProperties(tableAndCategoryAndModuleAndExteranlProp, this.defaultProperties);
    }

    public void setFieldValue(String name, Object value) {
        PropertiesChecker.isPropertySuitableForLevel(InheritanceLevel.TABLE, name);
        PropertiesChecker.isPropertySuitableForTableType(name, this.currentTableType);
        super.setFieldValue(name, value);
    }

    @Override
    public Map<String, Object> getPropertiesDefinedInTable() {
        return super.getFieldValues();
    }

    @Override
    public Map<String, Object> getPropertiesDefinedInTableIgnoreSystem() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Object> propDefinedInTable = this.getPropertiesDefinedInTable();
        for (Map.Entry<String, Object> property : propDefinedInTable.entrySet()) {
            String propName = property.getKey();
            TablePropertyDefinition propertyDefinition = TablePropertyDefinitionUtils.getPropertyByName(propName);
            if (propertyDefinition.isSystem()) continue;
            result.put(propName, property.getValue());
        }
        return result;
    }

    @Override
    public void setPropertiesAppliedForCategory(Map<String, Object> categoryProperties) {
        this.categoryProperties = categoryProperties;
    }

    @Override
    public Map<String, Object> getPropertiesAppliedForCategory() {
        return this.categoryProperties;
    }

    @Override
    public void setPropertiesAppliedForModule(Map<String, Object> moduleProperties) {
        this.moduleProperties = moduleProperties;
    }

    @Override
    public Map<String, Object> getPropertiesAppliedForModule() {
        return this.moduleProperties;
    }

    @Override
    public void setPropertiesAppliedByDefault(Map<String, Object> defaultProperties) {
        this.defaultProperties = defaultProperties;
    }

    @Override
    public Map<String, Object> getPropertiesAppliedByDefault() {
        return this.defaultProperties;
    }

    @Override
    public void setCurrentTableType(String currentTableType) {
        this.currentTableType = currentTableType;
    }

    @Override
    public String getCurrentTableType() {
        return this.currentTableType;
    }

    @Override
    public Map<String, Object> getExternalPropertiesAppliedForModule() {
        return this.externalModuleProperties;
    }

    @Override
    public void setExternalPropertiesAppliedForModule(Map<String, Object> moduleProperties) {
        this.externalModuleProperties = moduleProperties;
    }
}

