/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.properties.def;

import java.util.Date;
import org.openl.rules.enumeration.CountriesEnum;
import org.openl.rules.enumeration.CurrenciesEnum;
import org.openl.rules.enumeration.LanguagesEnum;
import org.openl.rules.enumeration.RegionsEnum;
import org.openl.rules.enumeration.UsRegionsEnum;
import org.openl.rules.enumeration.UsStatesEnum;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.table.constraints.Constraints;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.expressions.match.MatchingExpression;
import org.openl.rules.table.properties.inherit.InheritanceLevel;
import org.openl.types.IOpenClass;
import org.openl.types.java.JavaOpenClass;

public class DefaultPropertyDefinitions {
    private static final TablePropertyDefinition[] definitions = new TablePropertyDefinition[24];

    public static TablePropertyDefinition[] getDefaultDefinitions() {
        return definitions;
    }

    static {
        DefaultPropertyDefinitions.definitions[0] = new TablePropertyDefinition();
        definitions[0].setBusinessSearch(true);
        definitions[0].setConstraints(new Constraints("unique in:module"));
        definitions[0].setDescription("The name of the table, should be unique");
        definitions[0].setDimensional(false);
        definitions[0].setDisplayName("Name");
        definitions[0].setGroup("Info");
        definitions[0].setInheritanceLevel(new InheritanceLevel[]{InheritanceLevel.TABLE});
        definitions[0].setName("name");
        definitions[0].setPrimaryKey(false);
        definitions[0].setSecurityFilter("no");
        definitions[0].setSystem(false);
        definitions[0].setType((IOpenClass)JavaOpenClass.getOpenClass(String.class));
        DefaultPropertyDefinitions.definitions[1] = new TablePropertyDefinition();
        definitions[1].setBusinessSearch(true);
        definitions[1].setConstraints(new Constraints("no"));
        definitions[1].setDescription("The category of the table, could be two-level, in this case use format: <category> - <subcategory>");
        definitions[1].setDimensional(false);
        definitions[1].setDisplayName("Category");
        definitions[1].setGroup("Info");
        definitions[1].setInheritanceLevel(new InheritanceLevel[]{InheritanceLevel.CATEGORY, InheritanceLevel.TABLE});
        definitions[1].setName("category");
        definitions[1].setPrimaryKey(false);
        definitions[1].setSecurityFilter("yes (coma separated filter specification by user role: category/role pairs)");
        definitions[1].setSystem(false);
        definitions[1].setType((IOpenClass)JavaOpenClass.getOpenClass(String.class));
        DefaultPropertyDefinitions.definitions[2] = new TablePropertyDefinition();
        definitions[2].setBusinessSearch(true);
        definitions[2].setConstraints(new Constraints("no"));
        definitions[2].setDescription("The description of the table component");
        definitions[2].setDimensional(false);
        definitions[2].setDisplayName("Description");
        definitions[2].setGroup("Info");
        definitions[2].setInheritanceLevel(new InheritanceLevel[]{InheritanceLevel.TABLE});
        definitions[2].setName("description");
        definitions[2].setPrimaryKey(false);
        definitions[2].setSecurityFilter("no");
        definitions[2].setSystem(false);
        definitions[2].setType((IOpenClass)JavaOpenClass.getOpenClass(String.class));
        DefaultPropertyDefinitions.definitions[3] = new TablePropertyDefinition();
        definitions[3].setBusinessSearch(true);
        definitions[3].setConstraints(new Constraints("no"));
        definitions[3].setDescription("Add any number of comma-separated tags, could be used for search");
        definitions[3].setDimensional(false);
        definitions[3].setDisplayName("Tags");
        definitions[3].setGroup("Info");
        definitions[3].setInheritanceLevel(new InheritanceLevel[]{InheritanceLevel.TABLE});
        definitions[3].setName("tags");
        definitions[3].setPrimaryKey(false);
        definitions[3].setSecurityFilter("no");
        definitions[3].setSystem(false);
        definitions[3].setType((IOpenClass)JavaOpenClass.getOpenClass(String[].class));
        DefaultPropertyDefinitions.definitions[4] = new TablePropertyDefinition();
        definitions[4].setBusinessSearch(true);
        definitions[4].setConstraints(new Constraints("< expirationDate"));
        definitions[4].setDescription("The table becomes active on effective date and inactive after the expiration date. You can have multiple instances of the same table in the same module with different effective/expiration date ranges");
        definitions[4].setDimensional(true);
        definitions[4].setDisplayName("Effective Date");
        definitions[4].setExpression(new MatchingExpression("le(currentDate)"));
        definitions[4].setFormat("MM/dd/yyyy");
        definitions[4].setGroup("Business Dimension");
        definitions[4].setInheritanceLevel(new InheritanceLevel[]{InheritanceLevel.MODULE, InheritanceLevel.CATEGORY, InheritanceLevel.TABLE});
        definitions[4].setName("effectiveDate");
        definitions[4].setPrimaryKey(true);
        definitions[4].setSecurityFilter("no");
        definitions[4].setSystem(false);
        definitions[4].setType((IOpenClass)JavaOpenClass.getOpenClass(Date.class));
        DefaultPropertyDefinitions.definitions[5] = new TablePropertyDefinition();
        definitions[5].setBusinessSearch(true);
        definitions[5].setConstraints(new Constraints("> effectiveDate"));
        definitions[5].setDescription("The table becomes active on effective date and inactive after the expiration date. You can have multiple instances of the same table in the same module with different effective/expiration date");
        definitions[5].setDimensional(true);
        definitions[5].setDisplayName("Expiration Date");
        definitions[5].setExpression(new MatchingExpression("gt(currentDate)"));
        definitions[5].setFormat("MM/dd/yyyy");
        definitions[5].setGroup("Business Dimension");
        definitions[5].setInheritanceLevel(new InheritanceLevel[]{InheritanceLevel.MODULE, InheritanceLevel.CATEGORY, InheritanceLevel.TABLE});
        definitions[5].setName("expirationDate");
        definitions[5].setPrimaryKey(false);
        definitions[5].setSecurityFilter("no");
        definitions[5].setSystem(false);
        definitions[5].setType((IOpenClass)JavaOpenClass.getOpenClass(Date.class));
        DefaultPropertyDefinitions.definitions[6] = new TablePropertyDefinition();
        definitions[6].setBusinessSearch(true);
        definitions[6].setConstraints(new Constraints("no"));
        definitions[6].setDescription("User Name");
        definitions[6].setDimensional(false);
        definitions[6].setDisplayName("Created By");
        definitions[6].setGroup("Info");
        definitions[6].setInheritanceLevel(new InheritanceLevel[]{InheritanceLevel.TABLE});
        definitions[6].setName("createdBy");
        definitions[6].setPrimaryKey(false);
        definitions[6].setSecurityFilter("no");
        definitions[6].setSystem(true);
        definitions[6].setSystemValueDescriptor("currentUser");
        definitions[6].setSystemValuePolicy(TablePropertyDefinition.SystemValuePolicy.IF_BLANK_ONLY);
        definitions[6].setType((IOpenClass)JavaOpenClass.getOpenClass(String.class));
        DefaultPropertyDefinitions.definitions[7] = new TablePropertyDefinition();
        definitions[7].setBusinessSearch(true);
        definitions[7].setConstraints(new Constraints("no"));
        definitions[7].setDescription("The date of the table creation");
        definitions[7].setDimensional(false);
        definitions[7].setDisplayName("Created On");
        definitions[7].setFormat("MM/dd/yyyy");
        definitions[7].setGroup("Info");
        definitions[7].setInheritanceLevel(new InheritanceLevel[]{InheritanceLevel.TABLE});
        definitions[7].setName("createdOn");
        definitions[7].setPrimaryKey(false);
        definitions[7].setSecurityFilter("no");
        definitions[7].setSystem(true);
        definitions[7].setSystemValueDescriptor("currentDate");
        definitions[7].setSystemValuePolicy(TablePropertyDefinition.SystemValuePolicy.IF_BLANK_ONLY);
        definitions[7].setType((IOpenClass)JavaOpenClass.getOpenClass(Date.class));
        DefaultPropertyDefinitions.definitions[8] = new TablePropertyDefinition();
        definitions[8].setBusinessSearch(false);
        definitions[8].setConstraints(new Constraints("no"));
        definitions[8].setDescription("User Name");
        definitions[8].setDimensional(false);
        definitions[8].setDisplayName("Modified By");
        definitions[8].setGroup("Info");
        definitions[8].setInheritanceLevel(new InheritanceLevel[]{InheritanceLevel.TABLE});
        definitions[8].setName("modifiedBy");
        definitions[8].setPrimaryKey(false);
        definitions[8].setSecurityFilter("no");
        definitions[8].setSystem(true);
        definitions[8].setSystemValueDescriptor("currentUser");
        definitions[8].setSystemValuePolicy(TablePropertyDefinition.SystemValuePolicy.ON_EACH_EDIT);
        definitions[8].setType((IOpenClass)JavaOpenClass.getOpenClass(String.class));
        DefaultPropertyDefinitions.definitions[9] = new TablePropertyDefinition();
        definitions[9].setBusinessSearch(false);
        definitions[9].setConstraints(new Constraints("no"));
        definitions[9].setDescription("The date of the last table modification");
        definitions[9].setDimensional(false);
        definitions[9].setDisplayName("Modified On");
        definitions[9].setFormat("MM/dd/yyyy");
        definitions[9].setGroup("Info");
        definitions[9].setInheritanceLevel(new InheritanceLevel[]{InheritanceLevel.TABLE});
        definitions[9].setName("modifiedOn");
        definitions[9].setPrimaryKey(false);
        definitions[9].setSecurityFilter("no");
        definitions[9].setSystem(true);
        definitions[9].setSystemValueDescriptor("currentDate");
        definitions[9].setSystemValuePolicy(TablePropertyDefinition.SystemValuePolicy.ON_EACH_EDIT);
        definitions[9].setType((IOpenClass)JavaOpenClass.getOpenClass(Date.class));
        DefaultPropertyDefinitions.definitions[10] = new TablePropertyDefinition();
        definitions[10].setBusinessSearch(false);
        definitions[10].setConstraints(new Constraints("one of: common, vocabulary[N], main[N]"));
        definitions[10].setDescription("Used to manage dependencies between build phases");
        definitions[10].setDimensional(false);
        definitions[10].setDisplayName("Build Phase");
        definitions[10].setGroup("Dev");
        definitions[10].setInheritanceLevel(new InheritanceLevel[]{InheritanceLevel.MODULE, InheritanceLevel.CATEGORY, InheritanceLevel.TABLE});
        definitions[10].setName("buildPhase");
        definitions[10].setPrimaryKey(false);
        definitions[10].setSecurityFilter("no");
        definitions[10].setSystem(false);
        definitions[10].setType((IOpenClass)JavaOpenClass.getOpenClass(String.class));
        DefaultPropertyDefinitions.definitions[11] = new TablePropertyDefinition();
        definitions[11].setBusinessSearch(false);
        definitions[11].setConstraints(new Constraints("one of: on, off, gaps, overlaps"));
        definitions[11].setDescription("Defines gap/overlap validation mode for Decision Table");
        definitions[11].setDimensional(false);
        definitions[11].setDisplayName("Validate DT");
        definitions[11].setGroup("Dev");
        definitions[11].setInheritanceLevel(new InheritanceLevel[]{InheritanceLevel.MODULE, InheritanceLevel.CATEGORY, InheritanceLevel.TABLE});
        definitions[11].setName("validateDT");
        definitions[11].setPrimaryKey(false);
        definitions[11].setSecurityFilter("no");
        definitions[11].setSystem(false);
        definitions[11].setTableType(new XlsNodeTypes[]{XlsNodeTypes.XLS_DT});
        definitions[11].setType((IOpenClass)JavaOpenClass.getOpenClass(String.class));
        DefaultPropertyDefinitions.definitions[12] = new TablePropertyDefinition();
        definitions[12].setBusinessSearch(true);
        definitions[12].setConstraints(new Constraints("list: Defined by method getLob()"));
        definitions[12].setDescription("Defines the list of active LOBs for this table");
        definitions[12].setDimensional(true);
        definitions[12].setDisplayName("LOB");
        definitions[12].setExpression(new MatchingExpression("eq(lob)"));
        definitions[12].setGroup("Business Dimension");
        definitions[12].setInheritanceLevel(new InheritanceLevel[]{InheritanceLevel.MODULE, InheritanceLevel.CATEGORY, InheritanceLevel.TABLE});
        definitions[12].setName("lob");
        definitions[12].setPrimaryKey(false);
        definitions[12].setSecurityFilter("yes (coma separated filter specification by user role: category/role pairs)");
        definitions[12].setSystem(false);
        definitions[12].setType((IOpenClass)JavaOpenClass.getOpenClass(String.class));
        DefaultPropertyDefinitions.definitions[13] = new TablePropertyDefinition();
        definitions[13].setBusinessSearch(true);
        definitions[13].setConstraints(new Constraints("data: usRegions"));
        definitions[13].setDescription("US Region");
        definitions[13].setDimensional(true);
        definitions[13].setDisplayName("US Region");
        definitions[13].setExpression(new MatchingExpression("eq(usRegion)"));
        definitions[13].setGroup("Business Dimension");
        definitions[13].setInheritanceLevel(new InheritanceLevel[]{InheritanceLevel.MODULE, InheritanceLevel.CATEGORY, InheritanceLevel.TABLE});
        definitions[13].setName("usregion");
        definitions[13].setPrimaryKey(false);
        definitions[13].setSecurityFilter("yes (coma separated filter specification by user role: category/role pairs)");
        definitions[13].setSystem(false);
        definitions[13].setType((IOpenClass)JavaOpenClass.getOpenClass(UsRegionsEnum.class));
        DefaultPropertyDefinitions.definitions[14] = new TablePropertyDefinition();
        definitions[14].setBusinessSearch(false);
        definitions[14].setConstraints(new Constraints("data: countries"));
        definitions[14].setDescription("Country");
        definitions[14].setDimensional(true);
        definitions[14].setDisplayName("Countries");
        definitions[14].setExpression(new MatchingExpression("contains(country)"));
        definitions[14].setGroup("Business Dimension");
        definitions[14].setInheritanceLevel(new InheritanceLevel[]{InheritanceLevel.MODULE, InheritanceLevel.CATEGORY, InheritanceLevel.TABLE});
        definitions[14].setName("country");
        definitions[14].setPrimaryKey(false);
        definitions[14].setSecurityFilter("yes (coma separated filter specification by user role: category/role pairs)");
        definitions[14].setSystem(false);
        definitions[14].setType((IOpenClass)JavaOpenClass.getOpenClass(CountriesEnum[].class));
        DefaultPropertyDefinitions.definitions[15] = new TablePropertyDefinition();
        definitions[15].setBusinessSearch(false);
        definitions[15].setConstraints(new Constraints("data: currencies"));
        definitions[15].setDefaultValue("USD");
        definitions[15].setDescription("Currency");
        definitions[15].setDimensional(false);
        definitions[15].setDisplayName("Currency");
        definitions[15].setGroup("Business Dimension");
        definitions[15].setInheritanceLevel(new InheritanceLevel[]{InheritanceLevel.MODULE, InheritanceLevel.CATEGORY, InheritanceLevel.TABLE});
        definitions[15].setName("currency");
        definitions[15].setPrimaryKey(false);
        definitions[15].setSecurityFilter("no");
        definitions[15].setSystem(false);
        definitions[15].setType((IOpenClass)JavaOpenClass.getOpenClass(CurrenciesEnum.class));
        DefaultPropertyDefinitions.definitions[16] = new TablePropertyDefinition();
        definitions[16].setBusinessSearch(false);
        definitions[16].setConstraints(new Constraints("data: languages"));
        definitions[16].setDefaultValue("EN");
        definitions[16].setDescription("Language");
        definitions[16].setDimensional(false);
        definitions[16].setDisplayName("Language");
        definitions[16].setGroup("Business Dimension");
        definitions[16].setInheritanceLevel(new InheritanceLevel[]{InheritanceLevel.MODULE, InheritanceLevel.CATEGORY, InheritanceLevel.TABLE});
        definitions[16].setName("lang");
        definitions[16].setPrimaryKey(false);
        definitions[16].setSecurityFilter("no");
        definitions[16].setSystem(false);
        definitions[16].setType((IOpenClass)JavaOpenClass.getOpenClass(LanguagesEnum.class));
        DefaultPropertyDefinitions.definitions[17] = new TablePropertyDefinition();
        definitions[17].setBusinessSearch(true);
        definitions[17].setConstraints(new Constraints("data: usStates"));
        definitions[17].setDescription("US State");
        definitions[17].setDimensional(true);
        definitions[17].setDisplayName("US States");
        definitions[17].setExpression(new MatchingExpression("contains(usState)"));
        definitions[17].setGroup("Business Dimension");
        definitions[17].setInheritanceLevel(new InheritanceLevel[]{InheritanceLevel.MODULE, InheritanceLevel.CATEGORY, InheritanceLevel.TABLE});
        definitions[17].setName("state");
        definitions[17].setPrimaryKey(false);
        definitions[17].setSecurityFilter("yes (coma separated filter specification by user role: category/role pairs)");
        definitions[17].setSystem(false);
        definitions[17].setType((IOpenClass)JavaOpenClass.getOpenClass(UsStatesEnum[].class));
        DefaultPropertyDefinitions.definitions[18] = new TablePropertyDefinition();
        definitions[18].setBusinessSearch(true);
        definitions[18].setConstraints(new Constraints("data: regions"));
        definitions[18].setDescription("Economic Region");
        definitions[18].setDimensional(false);
        definitions[18].setDisplayName("Region");
        definitions[18].setGroup("Business Dimension");
        definitions[18].setInheritanceLevel(new InheritanceLevel[]{InheritanceLevel.MODULE, InheritanceLevel.CATEGORY});
        definitions[18].setName("region");
        definitions[18].setPrimaryKey(false);
        definitions[18].setSecurityFilter("yes (coma separated filter specification by user role: category/role pairs)");
        definitions[18].setSystem(false);
        definitions[18].setType((IOpenClass)JavaOpenClass.getOpenClass(RegionsEnum.class));
        DefaultPropertyDefinitions.definitions[19] = new TablePropertyDefinition();
        definitions[19].setBusinessSearch(false);
        definitions[19].setConstraints(new Constraints("NN.NN[.NN]"));
        definitions[19].setDescription("Version is a dimension with a specific constraint - one and only one version must be active(per dimension), the dispatch is done automatically to the active version");
        definitions[19].setDimensional(false);
        definitions[19].setDisplayName("Version");
        definitions[19].setGroup("Version");
        definitions[19].setInheritanceLevel(new InheritanceLevel[]{InheritanceLevel.TABLE});
        definitions[19].setName("version");
        definitions[19].setPrimaryKey(false);
        definitions[19].setSystem(false);
        definitions[19].setTableType(new XlsNodeTypes[]{XlsNodeTypes.XLS_DT, XlsNodeTypes.XLS_SPREADSHEET, XlsNodeTypes.XLS_TBASIC, XlsNodeTypes.XLS_COLUMN_MATCH, XlsNodeTypes.XLS_METHOD});
        definitions[19].setType((IOpenClass)JavaOpenClass.getOpenClass(String.class));
        DefaultPropertyDefinitions.definitions[20] = new TablePropertyDefinition();
        definitions[20].setBusinessSearch(false);
        definitions[20].setConstraints(new Constraints("unique in:TableGroup"));
        definitions[20].setDefaultValue("true");
        definitions[20].setDescription("Indicates an active version");
        definitions[20].setDimensional(false);
        definitions[20].setDisplayName("Active");
        definitions[20].setGroup("Version");
        definitions[20].setInheritanceLevel(new InheritanceLevel[]{InheritanceLevel.TABLE});
        definitions[20].setName("active");
        definitions[20].setPrimaryKey(false);
        definitions[20].setSystem(false);
        definitions[20].setTableType(new XlsNodeTypes[]{XlsNodeTypes.XLS_DT, XlsNodeTypes.XLS_SPREADSHEET, XlsNodeTypes.XLS_TBASIC, XlsNodeTypes.XLS_COLUMN_MATCH, XlsNodeTypes.XLS_METHOD});
        definitions[20].setType((IOpenClass)JavaOpenClass.getOpenClass(Boolean.class));
        DefaultPropertyDefinitions.definitions[21] = new TablePropertyDefinition();
        definitions[21].setBusinessSearch(false);
        definitions[21].setDefaultValue("false");
        definitions[21].setDescription("Raises an error if no rules were matched. The error will display at least parameter set, if possible trace(not complete)");
        definitions[21].setDimensional(false);
        definitions[21].setDisplayName("Fail On Miss");
        definitions[21].setGroup("Dev");
        definitions[21].setInheritanceLevel(new InheritanceLevel[]{InheritanceLevel.MODULE, InheritanceLevel.CATEGORY, InheritanceLevel.TABLE});
        definitions[21].setName("failOnMiss");
        definitions[21].setPrimaryKey(false);
        definitions[21].setSystem(false);
        definitions[21].setTableType(new XlsNodeTypes[]{XlsNodeTypes.XLS_DT});
        definitions[21].setType((IOpenClass)JavaOpenClass.getOpenClass(Boolean.class));
        DefaultPropertyDefinitions.definitions[22] = new TablePropertyDefinition();
        definitions[22].setBusinessSearch(true);
        definitions[22].setConstraints(new Constraints("Worksheet, Workbook, Module"));
        definitions[22].setDescription("Defines scope for properties");
        definitions[22].setDimensional(false);
        definitions[22].setDisplayName("Scope");
        definitions[22].setGroup("Dev");
        definitions[22].setInheritanceLevel(new InheritanceLevel[]{InheritanceLevel.MODULE, InheritanceLevel.CATEGORY});
        definitions[22].setName("scope");
        definitions[22].setPrimaryKey(false);
        definitions[22].setSystem(false);
        definitions[22].setTableType(new XlsNodeTypes[]{XlsNodeTypes.XLS_PROPERTIES});
        definitions[22].setType((IOpenClass)JavaOpenClass.getOpenClass(String.class));
        DefaultPropertyDefinitions.definitions[23] = new TablePropertyDefinition();
        definitions[23].setBusinessSearch(false);
        definitions[23].setConstraints(new Constraints("Worksheet, Workbook, Module"));
        definitions[23].setDefaultValue("org.openl.generated.beans");
        definitions[23].setDescription("Defines the name of the package for datatype generation");
        definitions[23].setDimensional(false);
        definitions[23].setDisplayName("Datatype Package");
        definitions[23].setGroup("Dev");
        definitions[23].setInheritanceLevel(new InheritanceLevel[]{InheritanceLevel.MODULE, InheritanceLevel.TABLE});
        definitions[23].setName("datatypePackage");
        definitions[23].setPrimaryKey(false);
        definitions[23].setSystem(false);
        definitions[23].setTableType(new XlsNodeTypes[]{XlsNodeTypes.XLS_DATATYPE});
        definitions[23].setType((IOpenClass)JavaOpenClass.getOpenClass(String.class));
    }
}

