/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.properties.expressions.match;

import org.apache.commons.lang.StringUtils;
import org.openl.exception.OpenLRuntimeException;
import org.openl.rules.table.properties.expressions.match.IMatchingExpression;
import org.openl.rules.table.properties.expressions.match.MatchingExpressionFactory;

public class MatchingExpressionsParser {
    public static IMatchingExpression parse(String matchingExpressionStr) {
        String operationName = null;
        String contextAttribute = null;
        if (!StringUtils.isNotEmpty((String)matchingExpressionStr)) {
            throw new OpenLRuntimeException("Matching expression string is null");
        }
        int openBracketIndex = matchingExpressionStr.indexOf("(");
        int closeBracketIndex = matchingExpressionStr.indexOf(")");
        operationName = matchingExpressionStr.substring(0, openBracketIndex).toUpperCase();
        contextAttribute = matchingExpressionStr.substring(openBracketIndex + 1, closeBracketIndex);
        if (StringUtils.isEmpty((String)operationName) || StringUtils.isEmpty((String)contextAttribute)) {
            throw new OpenLRuntimeException("Wrong matching expression format. Expected: <operationName>(<contextAttribute>)");
        }
        MatchingExpressionFactory metchExpressionFactory = new MatchingExpressionFactory();
        return metchExpressionFactory.getMatchingExpression(operationName, contextAttribute);
    }
}

