/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.properties.inherit;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.rules.table.properties.inherit.InheritanceLevel;

public class PropertiesChecker {
    private static final Log LOG = LogFactory.getLog(PropertiesChecker.class);

    public static boolean isPropertySuitableForLevel(InheritanceLevel currentLevel, String propertyName) {
        boolean result = false;
        TablePropertyDefinition propertyDefinition = TablePropertyDefinitionUtils.getPropertyByName(propertyName);
        if (propertyDefinition != null) {
            InheritanceLevel[] inheritanceLevels = propertyDefinition.getInheritanceLevel();
            if (inheritanceLevels != null && inheritanceLevels.length > 0) {
                if (Arrays.asList(inheritanceLevels).contains((Object)currentLevel)) {
                    result = true;
                }
            } else {
                LOG.debug((Object)String.format("Inheritance levels were not defined for property with name [%s].", propertyName));
            }
        } else {
            LOG.debug((Object)String.format("There is no such property in Definitions with name [%s].", propertyName));
        }
        return result;
    }

    public static boolean isPropertySuitableForTableType(String propertyName, String tableType) {
        XlsNodeTypes[] definitionTableTypes = TablePropertyDefinitionUtils.getSuitableTableTypes(propertyName);
        if (definitionTableTypes != null) {
            for (XlsNodeTypes nodeType : definitionTableTypes) {
                if (!nodeType.toString().equals(tableType)) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }
}

