/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.ui;

import org.openl.rules.table.AGrid;
import org.openl.rules.table.FormattedCell;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGrid;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.ui.filters.IGridFilter;

public class FilteredGrid
extends AGrid {
    private IGridFilter[] formatFilters;
    protected IGrid delegate;

    public FilteredGrid(IGrid delegate, IGridFilter[] formatFilters) {
        this.delegate = delegate;
        this.formatFilters = (IGridFilter[])formatFilters.clone();
    }

    private void formatCell(FormattedCell fcell, int col, int row) {
        if (this.formatFilters != null) {
            for (int i = 0; i < this.formatFilters.length; ++i) {
                if (this.formatFilters[i].getGridSelector() != null && !this.formatFilters[i].getGridSelector().selectCoords(col, row)) continue;
                try {
                    this.formatFilters[i].filterFormat(fcell);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
        }
    }

    public ICell getCell(int column, int row) {
        if (this.isEmpty(column, row)) {
            this.delegate.getCell(column, row);
        }
        return this.getFormattedCell(column, row);
    }

    public synchronized FormattedCell getFormattedCell(int col, int row) {
        FormattedCell cellToFormat = new FormattedCell(this.delegate.getCell(col, row));
        this.formatCell(cellToFormat, col, row);
        return cellToFormat;
    }

    public int getColumnWidth(int col) {
        return this.delegate.getColumnWidth(col);
    }

    public int getMaxColumnIndex(int row) {
        return this.delegate.getMaxColumnIndex(row);
    }

    public int getMaxRowIndex() {
        return this.delegate.getMaxRowIndex();
    }

    public IGridRegion getMergedRegion(int i) {
        return this.delegate.getMergedRegion(i);
    }

    public int getMinColumnIndex(int row) {
        return this.delegate.getMaxColumnIndex(row);
    }

    public int getMinRowIndex() {
        return this.delegate.getMinRowIndex();
    }

    public int getNumberOfMergedRegions() {
        return this.delegate.getNumberOfMergedRegions();
    }

    public String getRangeUri(int colStart, int rowStart, int colEnd, int rowEnd) {
        return this.delegate.getRangeUri(colStart, rowStart, colEnd, rowEnd);
    }

    public IGridRegion getRegionStartingAt(int colFrom, int rowFrom) {
        return this.delegate.getRegionStartingAt(colFrom, rowFrom);
    }

    public String getUri() {
        return this.delegate.getUri();
    }

    public boolean isEmpty(int col, int row) {
        return this.delegate.isEmpty(col, row);
    }

    public boolean isPartOfTheMergedRegion(int col, int row) {
        return this.delegate.isPartOfTheMergedRegion(col, row);
    }

    public IGridRegion getRegionContaining(int column, int row) {
        return this.delegate.getRegionContaining(column, row);
    }
}

