/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.ui.filters;

import org.openl.rules.table.FormattedCell;
import org.openl.rules.table.ui.CellFont;
import org.openl.rules.table.ui.CellStyle;
import org.openl.rules.table.ui.IGridSelector;
import org.openl.rules.table.ui.filters.AGridFilter;
import org.openl.rules.table.ui.filters.IColorFilter;
import org.openl.rules.table.ui.filters.TransparentColorFilter;
import org.openl.util.formatters.IFormatter;

public class ColorGridFilter
extends AGridFilter {
    public static final int FONT = 1;
    public static final int BACKGROUND = 2;
    public static final int BORDERS = 4;
    public static final int ALL = 255;
    private int scope = 255;
    private IColorFilter filter;

    public static ColorGridFilter makeTransparentFilter(IGridSelector selector, double transparency, int color) {
        TransparentColorFilter tf = new TransparentColorFilter(color, transparency);
        return new ColorGridFilter(selector, tf);
    }

    public ColorGridFilter(IGridSelector selector, IColorFilter filter) {
        super(selector);
        this.filter = filter;
    }

    public ColorGridFilter(IGridSelector selector, IColorFilter filter, int scope) {
        super(selector);
        this.filter = filter;
        this.scope = scope;
    }

    public FormattedCell filterFormat(FormattedCell formattedCell) {
        short[][] bb;
        if ((this.scope & 1) != 0) {
            CellFont cellFont = (CellFont)formattedCell.getFont();
            short[] fc = cellFont.getFontColor();
            if (fc == null) {
                fc = IColorFilter.BLACK;
            }
            cellFont.setFontColor(this.filter.filterColor(fc));
        }
        CellStyle cellStyle = (CellStyle)formattedCell.getStyle();
        if ((this.scope & 2) != 0) {
            short[] bcg = cellStyle.getFillBackgroundColor();
            if (bcg == null) {
                bcg = IColorFilter.WHITE;
            }
            cellStyle.setFillBackgroundColor(this.filter.filterColor(bcg));
            short[] fg = cellStyle.getFillForegroundColor();
            if (fg == null) {
                fg = IColorFilter.WHITE;
            }
            cellStyle.setFillForegroundColor(this.filter.filterColor(fg));
        }
        if ((this.scope & 4) != 0 && (bb = cellStyle.getBorderRGB()) != null) {
            for (int i = 0; i < bb.length; ++i) {
                bb[i] = this.filter.filterColor(bb[i]);
            }
        }
        return formattedCell;
    }

    public IFormatter getFormatter() {
        return null;
    }
}

