/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.ui.filters;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.table.FormattedCell;
import org.openl.rules.table.ICell;
import org.openl.rules.table.ui.IGridSelector;
import org.openl.rules.table.ui.filters.FormatFilter;
import org.openl.rules.table.ui.filters.IGridFilter;
import org.openl.rules.table.xls.formatters.AXlsFormatter;
import org.openl.rules.table.xls.formatters.SegmentFormatter;
import org.openl.rules.table.xls.formatters.XlsArrayFormatter;
import org.openl.rules.table.xls.formatters.XlsBooleanFormatter;
import org.openl.rules.table.xls.formatters.XlsDateFormatter;
import org.openl.rules.table.xls.formatters.XlsEnumFormatter;
import org.openl.rules.table.xls.formatters.XlsFormattersManager;
import org.openl.rules.table.xls.formatters.XlsFormulaFormatter;
import org.openl.rules.table.xls.formatters.XlsNumberFormatter;
import org.openl.rules.table.xls.formatters.XlsStringFormatter;
import org.openl.types.IOpenClass;
import org.openl.util.formatters.IFormatter;

public class SimpleFormatFilter
implements IGridFilter {
    public static final String GENERAL_XLS_FORMAT = "General";
    private Map<String, IFormatter> existingFormatters = new HashMap<String, IFormatter>();

    public Object parse(String value) {
        throw new UnsupportedOperationException("This format does not parse");
    }

    public IGridSelector getGridSelector() {
        return null;
    }

    public FormattedCell filterFormat(FormattedCell cell) {
        IFormatter cellFormatter = this.getCellFormatter(cell);
        if (cellFormatter != null) {
            FormatFilter formatFilter = new FormatFilter(cellFormatter);
            Object cellValue = cell.getObjectValue();
            if (cellValue instanceof String) {
                Object cellObjectValue = formatFilter.parse(cellValue.toString());
                cell.setObjectValue(cellObjectValue);
            }
            FormattedCell formattedCell = formatFilter.filterFormat(cell);
            if (cellValue != null && formattedCell.getFormattedValue() == null) {
                formattedCell.setFormattedValue(cellValue.toString());
            }
            return formattedCell;
        }
        return cell;
    }

    private IFormatter getCellFormatter(ICell cell) {
        IOpenClass dataType;
        AXlsFormatter formatter = null;
        CellMetaInfo cellMetaInfo = cell.getMetaInfo();
        IOpenClass iOpenClass = dataType = cellMetaInfo == null ? null : cellMetaInfo.getDataType();
        if (dataType != null) {
            Class instanceClass = dataType.getInstanceClass();
            if (ClassUtils.isAssignable((Class)instanceClass, Number.class, (boolean)true)) {
                String format = cell.getStyle().getTextFormat();
                XlsNumberFormatter numberFormatter = this.findXlsNumberFormatter(format);
                formatter = cellMetaInfo.isMultiValue() ? new XlsArrayFormatter(numberFormatter) : numberFormatter;
            } else if (instanceClass == Date.class) {
                String format = cell.getStyle().getTextFormat();
                formatter = this.findXlsDateFormatter(format);
            } else if (instanceClass == Boolean.TYPE || instanceClass == Boolean.class) {
                formatter = new XlsBooleanFormatter();
            } else if (instanceClass.isEnum()) {
                XlsEnumFormatter enumFormatter = new XlsEnumFormatter(instanceClass);
                formatter = cellMetaInfo.isMultiValue() ? new XlsArrayFormatter(enumFormatter) : enumFormatter;
            } else {
                formatter = new XlsStringFormatter();
            }
            if (cell.getFormula() != null) {
                formatter = new XlsFormulaFormatter(formatter);
            }
        }
        return formatter;
    }

    private static boolean isGeneralFormat(String format) {
        return format == null || GENERAL_XLS_FORMAT.equalsIgnoreCase(format);
    }

    @Deprecated
    private XlsDateFormatter findXlsDateFormatter(String format) {
        IFormatter formatter;
        if (SimpleFormatFilter.isGeneralFormat(format)) {
            format = XlsDateFormatter.DEFAULT_XLS_DATE_FORMAT;
        }
        if ((formatter = this.existingFormatters.get(format)) instanceof XlsDateFormatter) {
            return (XlsDateFormatter)formatter;
        }
        XlsDateFormatter dateFormat = (XlsDateFormatter)XlsFormattersManager.getFormatter(Date.class, format);
        this.existingFormatters.put(format, dateFormat);
        return dateFormat;
    }

    @Deprecated
    private XlsNumberFormatter findXlsNumberFormatter(String format) {
        if (SimpleFormatFilter.isGeneralFormat(format)) {
            return XlsNumberFormatter.General;
        }
        IFormatter formatter = this.existingFormatters.get(format);
        if (formatter instanceof XlsNumberFormatter) {
            return (XlsNumberFormatter)formatter;
        }
        XlsNumberFormatter numberFormatter = XlsNumberFormatter.makeFormat(format, new HashMap<String, SegmentFormatter>());
        this.existingFormatters.put(format, numberFormatter);
        return numberFormatter;
    }

    public IFormatter getFormatter() {
        return null;
    }
}

