/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.ui.filters;

import org.openl.rules.table.FormattedCell;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ui.filters.AGridFilter;
import org.openl.util.formatters.IFormatter;

public class TableValueFilter
extends AGridFilter {
    private Model model;
    private int startX;
    private int startY;

    public TableValueFilter(IGridTable t, Model m) {
        this.model = m;
        this.startX = t.getGridColumn(0, 0);
        this.startY = t.getGridRow(0, 0);
    }

    public FormattedCell filterFormat(FormattedCell cell) {
        Object v = this.getCellValue(cell.getColumn(), cell.getRow());
        if (v != null) {
            cell.setObjectValue(v);
            cell.setFormattedValue(String.valueOf(v));
        }
        return cell;
    }

    public Object getCellValue(int column, int row) {
        Object v = this.model.getValue(column - this.startX, row - this.startY);
        return v;
    }

    public IFormatter getFormatter() {
        return null;
    }

    public static interface Model {
        public Object getValue(int var1, int var2);
    }
}

