/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.ui.filters;

import org.openl.rules.table.ui.filters.IColorFilter;

public class TransparentColorFilter
implements IColorFilter {
    private short[] filter;
    private double transparency;

    public TransparentColorFilter(int color, double transparency) {
        this.transparency = transparency;
        this.filter = new short[3];
        this.filter[0] = (short)(color >> 16 & 0xFF);
        this.filter[1] = (short)(color >> 8 & 0xFF);
        this.filter[2] = (short)(color >> 0 & 0xFF);
    }

    public TransparentColorFilter(short[] filter, double transparency) {
        this.filter = filter;
        this.transparency = transparency;
    }

    public short[] filterColor(short[] color) {
        short[] res = new short[3];
        if (color == null) {
            color = BLACK;
        }
        for (int i = 0; i < color.length; ++i) {
            res[i] = (short)((double)color[i] * this.transparency + (double)this.filter[i] * (1.0 - this.transparency));
            if (res[i] > 255) {
                res[i] = 255;
            }
            if (res[i] >= 0) continue;
            res[i] = 0;
        }
        return res;
    }
}

