/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.word;

import java.util.Date;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.hwpf.usermodel.RangeHack;
import org.apache.poi.hwpf.usermodel.TableCell;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.ui.ICellFont;
import org.openl.rules.table.ui.ICellStyle;

public class WordCell
implements ICell {
    TableCell tcell;
    boolean merged;
    int row;
    int column;

    public WordCell(TableCell tc, int row, int column) {
        this.tcell = tc;
        this.row = row;
        this.column = column;
    }

    public int getParEnd() {
        return RangeHack.getParStart((Range)this.tcell) + this.tcell.numParagraphs();
    }

    public int getParStart() {
        return RangeHack.getParStart((Range)this.tcell) + 1;
    }

    public String getStringValue() {
        String text = this.tcell.text();
        int len = text.length();
        if (len == 0) {
            return text;
        }
        if (text.charAt(len - 1) == '\u0007') {
            return text.substring(0, len - 1);
        }
        return text;
    }

    public String getUri() {
        return "wdParStart=" + this.getParStart() + "&" + "wdParEnd" + "=" + this.getParEnd();
    }

    public boolean isMerged() {
        return this.merged;
    }

    public void setMerged(boolean merged) {
        this.merged = merged;
    }

    public int getAbsoluteColumn() {
        return this.getColumn();
    }

    public int getAbsoluteRow() {
        return this.getRow();
    }

    public IGridRegion getAbsoluteRegion() {
        return this.getRegion();
    }

    public int getColumn() {
        return this.column;
    }

    public ICellFont getFont() {
        return null;
    }

    public String getFormula() {
        return null;
    }

    public int getHeight() {
        return 1;
    }

    public Object getObjectValue() {
        return this.getStringValue();
    }

    public IGridRegion getRegion() {
        return null;
    }

    public int getRow() {
        return this.row;
    }

    public ICellStyle getStyle() {
        return null;
    }

    public int getType() {
        return 1;
    }

    public int getWidth() {
        return 1;
    }

    public boolean hasNativeType() {
        return false;
    }

    public boolean getNativeBoolean() {
        throw new UnsupportedOperationException();
    }

    public double getNativeNumber() {
        throw new UnsupportedOperationException();
    }

    public Date getNativeDate() {
        throw new UnsupportedOperationException();
    }

    public int getNativeType() {
        throw new UnsupportedOperationException();
    }

    public CellMetaInfo getMetaInfo() {
        return null;
    }
}

