/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.word;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.poi.hwpf.usermodel.Table;
import org.apache.poi.hwpf.usermodel.TableCell;
import org.apache.poi.hwpf.usermodel.TableRow;
import org.openl.rules.indexer.WordTableElement;
import org.openl.rules.table.AGrid;
import org.openl.rules.table.GridRegion;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.word.WordCell;

public class WordGridModel
extends AGrid {
    WordTableElement wordTable;
    WordCell[][] grid;
    IGridRegion[] regions;

    public WordGridModel(WordTableElement wte) {
        this.wordTable = wte;
        new WordGridBuilder().buildModel(this, wte);
    }

    public int getCellHeight(int column, int row) {
        IGridRegion reg = this.getRegionContaining(column, row);
        if (reg == null) {
            return 1;
        }
        if (reg.getLeft() == column && reg.getTop() == row) {
            return IGridRegion.Tool.height(reg);
        }
        return 1;
    }

    public ICell getCell(int column, int row) {
        return this.grid[column][row];
    }

    public int getCellType(int column, int row) {
        return 1;
    }

    public String getCellUri(int column, int row) {
        return this.grid[column][row].getUri();
    }

    public int getCellWidth(int column, int row) {
        IGridRegion reg = this.getRegionContaining(column, row);
        if (reg == null) {
            return 1;
        }
        if (reg.getLeft() == column && reg.getTop() == row) {
            return IGridRegion.Tool.width(reg);
        }
        return 1;
    }

    public int getColumnWidth(int col) {
        return 0;
    }

    public String getFormattedCellValue(int column, int row) {
        return this.getStringCellValue(column, row);
    }

    public int getMaxColumnIndex(int row) {
        return this.grid.length - 1;
    }

    public int getMaxRowIndex() {
        return this.grid[0].length - 1;
    }

    public IGridRegion getMergedRegion(int i) {
        return this.regions[i];
    }

    public int getMinColumnIndex(int row) {
        return 0;
    }

    public int getMinRowIndex() {
        return 0;
    }

    public int getNumberOfMergedRegions() {
        return this.regions.length;
    }

    public Object getObjectCellValue(int column, int row) {
        return this.getStringCellValue(column, row);
    }

    public String getRangeUri(int colStart, int rowStart, int colEnd, int rowEnd) {
        WordCell wcStart = this.grid[colStart][rowStart];
        WordCell wcEnd = this.grid[colEnd][rowEnd];
        return this.getUri() + "&wdParStart=" + wcStart.getParStart() + "&wdParEnd=" + wcEnd.getParEnd();
    }

    public IGridRegion getRegionContaining(int column, int row) {
        for (int i = 0; i < this.regions.length; ++i) {
            if (!IGridRegion.Tool.contains(this.regions[i], column, row)) continue;
            return this.regions[i];
        }
        return null;
    }

    public IGridRegion getRegionStartingAt(int colFrom, int rowFrom) {
        IGridRegion reg = this.getRegionContaining(colFrom, rowFrom);
        return reg != null && reg.getLeft() == colFrom && reg.getTop() == rowFrom ? reg : null;
    }

    public String getStringCellValue(int column, int row) {
        return this.grid[column][row].getStringValue();
    }

    public String getUri() {
        return this.wordTable.getDocument().getUri() + "?_W";
    }

    public boolean isEmpty(int col, int row) {
        WordCell wc = this.grid[col][row];
        String text = wc.getStringValue();
        return text == null || text.length() == 0;
    }

    public boolean isPartOfTheMergedRegion(int col, int row) {
        IGridRegion gr = this.getRegionContaining(col, row);
        return gr != null;
    }

    public String getCellFormula(int column, int row) {
        return null;
    }

    static class WordGridBuilder {
        WordCell[][] grid;
        int nrows;
        int ncolumns;
        List<IGridRegion> regions = new ArrayList<IGridRegion>();
        List<IGridRegion> vregions = new ArrayList<IGridRegion>();
        TreeMap<Integer, Integer> wCells = new TreeMap();

        WordGridBuilder() {
        }

        public void buildModel(WordGridModel model, WordTableElement wte) {
            int i;
            Table wt = wte.getTable();
            this.nrows = wt.numRows();
            this.ncolumns = this.calcColumns(wt);
            this.grid = new WordCell[this.ncolumns][this.nrows];
            this.normalizeWidths();
            this.fillCells(wt);
            model.grid = this.grid;
            IGridRegion[] rr = new IGridRegion[this.regions.size() + this.vregions.size()];
            for (i = 0; i < this.regions.size(); ++i) {
                rr[i] = this.regions.get(i);
            }
            for (i = 0; i < this.vregions.size(); ++i) {
                rr[i + this.regions.size()] = this.vregions.get(i);
            }
            model.regions = rr;
        }

        private int calcColumns(Table wt) {
            for (int i = 0; i < wt.numRows(); ++i) {
                TableRow tr = wt.getRow(i);
                int ncells = tr.numCells();
                int w = 0;
                for (int j = 0; j < ncells; ++j) {
                    TableCell tc = tr.getCell(j);
                    this.wCells.put(w += tc.getWidth(), w);
                }
            }
            return this.wCells.size();
        }

        private void fillCells(Table wt) {
            for (int i = 0; i < wt.numRows(); ++i) {
                TableRow tr = wt.getRow(i);
                int ncells = tr.numCells();
                int w = 0;
                for (int j = 0; j < ncells; ++j) {
                    TableCell tc = tr.getCell(j);
                    int colFrom = this.getColumn(w);
                    int colTo = this.getColumn(w += tc.getWidth());
                    for (int k = colFrom; k < colTo; ++k) {
                        this.grid[k][i] = new WordCell(tc, i, k);
                    }
                    if (tc.isVerticallyMerged()) {
                        if (tc.text().length() > 1) {
                            this.startNewVRegion(colFrom, i, colTo - 1);
                            continue;
                        }
                        this.mergeVRegion(colFrom, i, colTo - 1);
                        continue;
                    }
                    if (colTo - colFrom <= 1) continue;
                    this.makeNewRegion(colFrom, i, colTo - 1);
                }
            }
        }

        int getColumn(int width) {
            if (width == 0) {
                return 0;
            }
            Integer ww = this.wCells.get(new Integer(width));
            if (ww == null) {
                throw new RuntimeException("Can not find width: " + width);
            }
            return ww;
        }

        private void makeNewRegion(int colFrom, int row, int colTo) {
            GridRegion gr = new GridRegion(row, colFrom, row, colTo);
            this.regions.add(gr);
        }

        private void mergeVRegion(int colFrom, int i, int colTo) {
            for (int j = 0; j < this.vregions.size(); ++j) {
                GridRegion gr = (GridRegion)this.vregions.get(j);
                if (gr.getLeft() != colFrom || gr.getRight() != colTo || gr.getBottom() != i - 1) continue;
                gr.setBottom(i);
                return;
            }
            this.startNewVRegion(colFrom, i, colTo);
        }

        private void normalizeWidths() {
            TreeMap<Integer, Integer> tm = new TreeMap<Integer, Integer>();
            int r = 0;
            for (Integer w : this.wCells.keySet()) {
                tm.put(w, new Integer(++r));
            }
            this.wCells = tm;
        }

        private void startNewVRegion(int colFrom, int i, int colTo) {
            GridRegion gr = new GridRegion(i, colFrom, i, colTo);
            this.vregions.add(gr);
        }
    }
}

