/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.word;

import java.io.File;
import java.net.URL;
import java.util.Map;
import org.openl.main.SourceCodeURLTool;
import org.openl.rules.table.syntax.XlsURLConstants;
import org.openl.util.RuntimeExceptionWrapper;

public class WordUrlParser
implements XlsURLConstants {
    public static final String FILE_PROTOCOL = "file:";
    public String wdPath;
    public String wdName;
    public String wdParStart;
    public String wdParEnd;

    static boolean endsWithSlash(String s) {
        return s.length() > 0 && WordUrlParser.isSlash(s.charAt(s.length() - 1));
    }

    static boolean isSlash(char c) {
        return c == '/' || c == '\\';
    }

    URL guessFileURL(String url) {
        int idx = (url = this.ltrimFileURL(url)).indexOf(58);
        if (idx == 0 || idx > 1) {
            return null;
        }
        try {
            File f = new File(url);
            return f.getCanonicalFile().toURI().toURL();
        }
        catch (Throwable t) {
            throw RuntimeExceptionWrapper.wrap((Throwable)t);
        }
    }

    String ltrimFileURL(String url) {
        if ((url = url.replace('\\', '/')).startsWith(FILE_PROTOCOL)) {
            url = url.substring(FILE_PROTOCOL.length());
        }
        if (url.indexOf(47) == 0 && url.indexOf(58) == 2) {
            url = url.substring(1);
        }
        return url;
    }

    public void parse(String url) throws Exception {
        Map urlMap = SourceCodeURLTool.parseUrl((String)url);
        String file = (String)urlMap.get("file");
        this.wdParStart = (String)urlMap.get("wdParNum");
        if (this.wdParStart == null) {
            this.wdParStart = (String)urlMap.get("wdParStart");
        }
        this.wdParEnd = (String)urlMap.get("wdParEnd");
        File f = new File(file).getCanonicalFile();
        this.wdPath = f.getParent();
        this.wdName = f.getName();
    }

    public String toCanonicalURL(String path) {
        String url = this.toURL(path).toExternalForm();
        url = this.ltrimFileURL(url);
        return url;
    }

    public String toCanonicalURL(String parent, String child) {
        String url = this.toCanonicalURL(parent);
        if (child != null && child.length() > 0) {
            url = url + '/' + child;
        }
        return url;
    }

    public URL toURL(String path) {
        URL url = this.guessFileURL(path);
        if (url != null) {
            return url;
        }
        try {
            return new URL(path);
        }
        catch (Throwable t) {
            throw RuntimeExceptionWrapper.wrap((Throwable)t);
        }
    }

    public URL[] toURL(String[] path) {
        URL[] urls = new URL[path.length];
        for (int i = 0; i < path.length; ++i) {
            urls[i] = this.toURL(path[i]);
        }
        return urls;
    }
}

