/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class PoiExcelHelper {
    public static void copyCellValue(Cell cellFrom, Cell cellTo) {
        if (cellTo.getCellType() == 2) {
            cellTo.setCellFormula(null);
        }
        cellTo.setCellType(3);
        switch (cellFrom.getCellType()) {
            case 3: {
                break;
            }
            case 4: {
                cellTo.setCellValue(cellFrom.getBooleanCellValue());
                break;
            }
            case 2: {
                cellTo.setCellFormula(cellFrom.getCellFormula());
                try {
                    PoiExcelHelper.evaluateFormula(cellTo);
                }
                catch (Exception exception) {}
                break;
            }
            case 0: {
                cellTo.setCellValue(cellFrom.getNumericCellValue());
                break;
            }
            case 1: {
                cellTo.setCellValue(cellFrom.getStringCellValue());
                break;
            }
            default: {
                throw new RuntimeException("Unknown cell type: " + cellFrom.getCellType());
            }
        }
    }

    public static void copyCellStyle(Cell cellFrom, Cell cellTo, Sheet sheet) {
        CellStyle styleFrom = cellFrom.getCellStyle();
        try {
            cellTo.setCellStyle(styleFrom);
        }
        catch (IllegalArgumentException e) {
            CellStyle styleTo = sheet.getWorkbook().createCellStyle();
            styleTo.cloneStyleFrom(styleFrom);
            cellTo.setCellStyle(styleTo);
        }
    }

    public static Cell getCell(int colIndex, int rowIndex, Sheet sheet) {
        Row row = sheet.getRow(rowIndex);
        if (row != null) {
            return row.getCell(colIndex);
        }
        return null;
    }

    public static Cell getOrCreateCell(int colIndex, int rowIndex, Sheet sheet) {
        Cell cell;
        Row row = sheet.getRow(rowIndex);
        if (row == null) {
            row = sheet.createRow(rowIndex);
        }
        if ((cell = row.getCell(colIndex)) == null) {
            cell = row.createCell(colIndex);
        }
        return cell;
    }

    public static int getColumnWidth(int col, Sheet sheet) {
        int w = sheet.getColumnWidth((int)((short)col));
        if (w == sheet.getDefaultColumnWidth()) {
            return 79;
        }
        return w / 40;
    }

    public static int getMaxColumnIndex(int rownum, Sheet sheet) {
        Row row = sheet.getRow(rownum);
        return row == null ? (short)0 : row.getLastCellNum();
    }

    public static int getMaxRowIndex(Sheet sheet) {
        return sheet.getLastRowNum();
    }

    public static int getMinColumnIndex(int rownum, Sheet sheet) {
        Row row = sheet.getRow(rownum);
        return row == null ? (short)0 : row.getFirstCellNum();
    }

    public static int getNumberOfMergedRegions(Sheet sheet) {
        try {
            return sheet.getNumMergedRegions();
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    public static int getMinRowIndex(Sheet sheet) {
        return sheet.getFirstRowNum();
    }

    public static boolean isEmptyCell(int x, int y, Sheet sheet) {
        Cell cell = PoiExcelHelper.getCell(x, y, sheet);
        if (cell == null) {
            return true;
        }
        if (cell.getCellType() == 3) {
            return true;
        }
        if (cell.getCellType() == 1) {
            String v = cell.getStringCellValue();
            return v == null || v.trim().length() == 0;
        }
        return false;
    }

    public static int getLastRowNum(Sheet sheet) {
        return sheet.getLastRowNum();
    }

    public static void setCellStringValue(int col, int row, String value, Sheet sheet) {
        Cell cell = PoiExcelHelper.getOrCreateCell(col, row, sheet);
        cell.setCellValue(value);
    }

    public static CellRangeAddress getMergedRegionAt(int index, Sheet sheet) {
        return sheet.getMergedRegion(index);
    }

    public static void evaluateFormula(Cell cell) throws Exception {
        FormulaEvaluator formulaEvaluator = cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
        formulaEvaluator.evaluateFormulaCell(cell);
    }
}

