/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls;

import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.table.GridRegion;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.ui.ICellFont;
import org.openl.rules.table.ui.ICellStyle;
import org.openl.rules.table.xls.IncorrectFormulaException;
import org.openl.rules.table.xls.PoiExcelHelper;
import org.openl.rules.table.xls.XlsCellFont;
import org.openl.rules.table.xls.XlsCellStyle;
import org.openl.rules.table.xls.XlsCellStyle2;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.rules.table.xls.XlsUtil;
import org.openl.rules.table.xls.writers.AXlsCellWriter;
import org.openl.util.NumberUtils;

public class XlsCell
implements ICell {
    private int column;
    private int row;
    private IGridRegion region;
    private Cell cell;
    private int width = 1;
    private int height = 1;
    private XlsSheetGridModel gridModel;

    private XlsCell(int column, int row, IGridRegion region, Cell cell) {
        this.column = column;
        this.row = row;
        this.region = region;
        this.cell = cell;
        if (region != null && region.getLeft() == column && region.getTop() == row) {
            this.width = region.getRight() - region.getLeft() + 1;
            this.height = region.getBottom() - region.getTop() + 1;
        }
    }

    public XlsCell(int column, int row, XlsSheetGridModel gridModel) {
        this(column, row, gridModel.getRegionContaining(column, row), PoiExcelHelper.getCell(column, row, gridModel.getSheetSource().getSheet()));
        this.gridModel = gridModel;
    }

    public ICellStyle getStyle() {
        if (this.cell == null) {
            return null;
        }
        return this.getCellStyle(this.cell);
    }

    public int getAbsoluteColumn() {
        return this.getColumn();
    }

    public int getAbsoluteRow() {
        return this.getRow();
    }

    public IGridRegion getAbsoluteRegion() {
        IGridRegion absoluteRegion = this.getRegion();
        if (absoluteRegion == null) {
            absoluteRegion = new GridRegion(this.row, this.column, this.row, this.column);
        }
        return absoluteRegion;
    }

    public int getColumn() {
        return this.column;
    }

    public ICellFont getFont() {
        if (this.cell == null) {
            return null;
        }
        Font font = this.gridModel.getSheetSource().getSheet().getWorkbook().getFontAt(this.cell.getCellStyle().getFontIndex());
        return new XlsCellFont(font, this.gridModel.getSheetSource().getSheet().getWorkbook());
    }

    public int getRow() {
        return this.row;
    }

    public IGridRegion getRegion() {
        return this.region;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public Object getObjectValue() {
        if (this.cell == null && this.region == null) {
            return null;
        }
        if (this.region != null) {
            return this.extractValueFromRegion();
        }
        return this.extractCellValue(true);
    }

    public void setObjectValue(Object value) {
        if (value != null) {
            boolean writeCellMetaInfo = true;
            if (this.gridModel.hasPredefinedStringArray(this.column, this.row)) {
                writeCellMetaInfo = false;
            }
            AXlsCellWriter cellWriter = this.gridModel.getCellWriter(this.cell.getCellType(), value);
            cellWriter.setCellToWrite(this.cell);
            cellWriter.setValueToWrite(value);
            cellWriter.writeCellValue(writeCellMetaInfo);
        } else {
            this.cell.setCellType(3);
        }
    }

    public String getStringValue() {
        Object res = null;
        try {
            res = this.getObjectValue();
        }
        catch (IncorrectFormulaException incorrectFormulaException) {
            // empty catch block
        }
        return res == null ? null : String.valueOf(res);
    }

    public void setStringValue(String value) {
        this.cell.setCellValue(value);
    }

    private ICell getTopLeftCellFromRegion() {
        int row = this.region.getTop();
        int col = this.region.getLeft();
        return this.gridModel.getCell(col, row);
    }

    private boolean isCurrentCellATopLeftCellInRegion() {
        ICell topLeftCell = this.getTopLeftCellFromRegion();
        return topLeftCell.getColumn() == this.column && topLeftCell.getRow() == this.row;
    }

    private Object extractValueFromRegion() {
        if (this.isCurrentCellATopLeftCellInRegion()) {
            return this.extractCellValue(true);
        }
        ICell topLeftCell = this.getTopLeftCellFromRegion();
        return topLeftCell.getObjectValue();
    }

    private Object extractCellValue(boolean useCachedValue) {
        if (this.cell != null) {
            int type = this.cell.getCellType();
            if (useCachedValue && type == 2) {
                type = this.cell.getCachedFormulaResultType();
            }
            switch (type) {
                case 3: {
                    return null;
                }
                case 4: {
                    return this.cell.getBooleanCellValue();
                }
                case 0: {
                    if (DateUtil.isCellDateFormatted((Cell)this.cell)) {
                        return this.cell.getDateCellValue();
                    }
                    double value = this.cell.getNumericCellValue();
                    return NumberUtils.intOrDouble((double)value);
                }
                case 1: {
                    return this.cell.getStringCellValue();
                }
                case 2: {
                    try {
                        PoiExcelHelper.evaluateFormula(this.cell);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return this.extractCellValue(true);
                }
            }
            return "unknown type: " + this.cell.getCellType();
        }
        return null;
    }

    public String getFormula() {
        if (this.cell == null && this.region == null) {
            return null;
        }
        if (this.region != null) {
            return this.getFormulaFromRegion();
        }
        return this.cellFormula();
    }

    private String getFormulaFromRegion() {
        if (this.isCurrentCellATopLeftCellInRegion()) {
            return this.cellFormula();
        }
        ICell topLeftCell = this.getTopLeftCellFromRegion();
        return topLeftCell.getType() == 2 ? topLeftCell.getFormula() : null;
    }

    private String cellFormula() {
        return this.cell.getCellType() == 2 ? this.cell.getCellFormula() : null;
    }

    public int getType() {
        if (this.cell == null && this.region == null) {
            return 3;
        }
        if (this.region != null) {
            return this.getTypeFromRegion();
        }
        return this.cell.getCellType();
    }

    private int getTypeFromRegion() {
        if (this.isCurrentCellATopLeftCellInRegion()) {
            return this.cell.getCellType();
        }
        ICell topLeftCell = this.getTopLeftCellFromRegion();
        return topLeftCell.getType();
    }

    public String getUri() {
        return XlsUtil.xlsCellPresentation(this.column, this.row);
    }

    public boolean getNativeBoolean() {
        return true;
    }

    public double getNativeNumber() {
        if (this.cell == null) {
            return 0.0;
        }
        return this.cell.getNumericCellValue();
    }

    public int getNativeType() {
        if (this.cell == null) {
            return 3;
        }
        int type = this.cell.getCellType();
        if (type == 2) {
            return this.cell.getCachedFormulaResultType();
        }
        return type;
    }

    public boolean hasNativeType() {
        return true;
    }

    public Date getNativeDate() {
        if (this.cell == null) {
            return null;
        }
        return this.cell.getDateCellValue();
    }

    public CellMetaInfo getMetaInfo() {
        return this.gridModel.getCellMetaInfo(this.column, this.row);
    }

    private ICellStyle getCellStyle(Cell cell) {
        CellStyle style = cell.getCellStyle();
        if (style != null) {
            Workbook workbook = this.gridModel.getSheetSource().getSheet().getWorkbook();
            if (style instanceof XSSFCellStyle) {
                return new XlsCellStyle2((XSSFCellStyle)style, (XSSFWorkbook)workbook);
            }
            return new XlsCellStyle((HSSFCellStyle)style, (HSSFWorkbook)workbook);
        }
        return null;
    }
}

