/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls;

import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openl.rules.table.ui.ICellFont;
import org.openl.rules.table.xls.XlsCellStyle;
import org.openl.rules.table.xls.XlsCellStyle2;

public class XlsCellFont
implements ICellFont {
    private Font font;
    private Workbook workbook;

    public XlsCellFont(Font font, Workbook workbook) {
        this.font = font;
        this.workbook = workbook;
    }

    public short[] getFontColor() {
        if (this.font instanceof XSSFFont) {
            XSSFColor color = ((XSSFFont)this.font).getXSSFColor();
            return XlsCellStyle2.colorToArray(color, (XSSFWorkbook)this.workbook);
        }
        short x = this.font.getColor();
        return XlsCellStyle.colorToArray(x, (HSSFWorkbook)this.workbook);
    }

    public String getName() {
        return this.font.getFontName();
    }

    public int getSize() {
        return this.font.getFontHeightInPoints();
    }

    public boolean isBold() {
        return this.font.getBoldweight() == 700;
    }

    public boolean isItalic() {
        return this.font.getItalic();
    }

    public boolean isStrikeout() {
        return this.font.getStrikeout();
    }

    public boolean isUnderlined() {
        return this.font.getUnderline() != 0;
    }
}

