/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls;

import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.openl.rules.table.ui.ICellStyle;

public class XlsCellStyle
implements ICellStyle {
    private HSSFCellStyle xlsStyle;
    private HSSFWorkbook workbook;

    public static short[] colorToArray(short x, HSSFWorkbook workbook) {
        HSSFColor cc = workbook.getCustomPalette().getColor(x);
        if (cc == null) {
            return null;
        }
        short[] rgb = cc.getTriplet();
        return rgb;
    }

    public XlsCellStyle(HSSFCellStyle xlsStyle, HSSFWorkbook workbook) {
        this.xlsStyle = xlsStyle;
        this.workbook = workbook;
    }

    public short[][] getBorderRGB() {
        short[] cc = new short[]{this.xlsStyle.getTopBorderColor(), this.xlsStyle.getRightBorderColor(), this.xlsStyle.getBottomBorderColor(), this.xlsStyle.getLeftBorderColor()};
        short[][] ccRgb = new short[4][];
        for (int i = 0; i < cc.length; ++i) {
            ccRgb[i] = XlsCellStyle.colorToArray(cc[i], this.workbook);
        }
        return ccRgb;
    }

    public short[] getBorderStyle() {
        short[] bb = new short[]{this.xlsStyle.getBorderTop(), this.xlsStyle.getBorderRight(), this.xlsStyle.getBorderBottom(), this.xlsStyle.getBorderLeft()};
        return bb;
    }

    public short[] getFillBackgroundColor() {
        if (this.hasNoFill()) {
            return null;
        }
        short x = this.xlsStyle.getFillBackgroundColor();
        return XlsCellStyle.colorToArray(x, this.workbook);
    }

    public short getFillBackgroundColorIndex() {
        return this.xlsStyle.getFillBackgroundColor();
    }

    public short getFillForegroundColorIndex() {
        return this.xlsStyle.getFillForegroundColor();
    }

    public short getFillPattern() {
        return this.xlsStyle.getFillPattern();
    }

    public boolean hasNoFill() {
        return this.xlsStyle.getFillPattern() == 0;
    }

    public short[] getFillForegroundColor() {
        if (this.hasNoFill()) {
            return null;
        }
        short x = this.xlsStyle.getFillForegroundColor();
        return XlsCellStyle.colorToArray(x, this.workbook);
    }

    public int getHorizontalAlignment() {
        return this.xlsStyle == null ? 0 : (int)this.xlsStyle.getAlignment();
    }

    public int getIdent() {
        return this.xlsStyle.getIndention();
    }

    public int getRotation() {
        return this.xlsStyle.getRotation();
    }

    public String getTextFormat() {
        return this.xlsStyle.getDataFormatString();
    }

    public int getVerticalAlignment() {
        return this.xlsStyle == null ? 0 : (int)this.xlsStyle.getVerticalAlignment();
    }

    public CellStyle getXlsStyle() {
        return this.xlsStyle;
    }

    public boolean isWrappedText() {
        return this.xlsStyle.getWrapText();
    }
}

