/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls;

import java.awt.Color;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.xmlbeans.XmlObject;
import org.openl.rules.table.ui.ICellStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTColorScheme;
import org.openxmlformats.schemas.drawingml.x2006.main.ThemeDocument;

public class XlsCellStyle2
implements ICellStyle {
    private static Hashtable<Integer, HSSFColor> oldIndexedColors = HSSFColor.getIndexHash();
    public static Map<XSSFWorkbook, ThemeDocument> themesCache = new HashMap<XSSFWorkbook, ThemeDocument>();
    private XSSFCellStyle xlsStyle;
    private XSSFWorkbook workbook;
    private ThemeDocument themeDocument;

    public static void cleareThemesCache() {
        themesCache.clear();
    }

    public XlsCellStyle2(XSSFCellStyle xlsStyle, XSSFWorkbook workbook) {
        this.xlsStyle = xlsStyle;
        this.workbook = workbook;
        this.init();
    }

    private void init() {
        try {
            if (themesCache.containsKey(this.workbook)) {
                this.themeDocument = themesCache.get(this.workbook);
            } else {
                POIXMLDocumentPart themePart = this.getTheme(this.workbook);
                if (themePart != null) {
                    this.themeDocument = ThemeDocument.Factory.parse((InputStream)themePart.getPackagePart().getInputStream());
                }
                themesCache.put(this.workbook, this.themeDocument);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public short[][] getBorderRGB() {
        short[][] ccRgb = new short[][]{this.colorToArray(this.xlsStyle.getTopBorderXSSFColor()), this.colorToArray(this.xlsStyle.getRightBorderXSSFColor()), this.colorToArray(this.xlsStyle.getBottomBorderXSSFColor()), this.colorToArray(this.xlsStyle.getLeftBorderXSSFColor())};
        return ccRgb;
    }

    public static short[] colorToArray(XSSFColor color, XSSFWorkbook workbook) {
        return new XlsCellStyle2(null, workbook).colorToArray(color);
    }

    private short[] colorToArray(XSSFColor color) {
        if (color == null) {
            return null;
        }
        byte[] rgb = color.getRgb();
        if (rgb == null) {
            Integer key = new Integer(color.getIndexed());
            HSSFColor c = oldIndexedColors.get(key);
            if (c != null) {
                return c.getTriplet();
            }
            if (this.themeDocument != null && color.getCTColor() != null && color.getCTColor().isSetTheme()) {
                org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor ctColor = color.getCTColor();
                int themeIndex = (int)ctColor.getTheme();
                double tint = ctColor.getTint();
                try {
                    return this.getThemeColorRgb(themeIndex, tint);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }
        short[] result = new short[3];
        for (int i = 1; i < 4; ++i) {
            result[i - 1] = (short)(rgb[i] & 0xFF);
        }
        return result;
    }

    public short[] getBorderStyle() {
        short[] bb = new short[]{this.xlsStyle.getBorderTop(), this.xlsStyle.getBorderRight(), this.xlsStyle.getBorderBottom(), this.xlsStyle.getBorderLeft()};
        return bb;
    }

    public boolean hasNoFill() {
        return this.xlsStyle.getFillPattern() == 0;
    }

    public short getFillPattern() {
        return this.xlsStyle.getFillPattern();
    }

    public short[] getFillBackgroundColor() {
        if (this.hasNoFill()) {
            return null;
        }
        return this.colorToArray(this.xlsStyle.getFillBackgroundXSSFColor());
    }

    public short[] getFillForegroundColor() {
        if (this.hasNoFill()) {
            return null;
        }
        return this.colorToArray(this.xlsStyle.getFillForegroundXSSFColor());
    }

    public short getFillBackgroundColorIndex() {
        return this.xlsStyle.getFillBackgroundColor();
    }

    public short getFillForegroundColorIndex() {
        return this.xlsStyle.getFillForegroundColor();
    }

    public int getHorizontalAlignment() {
        return this.xlsStyle == null ? 0 : (int)this.xlsStyle.getAlignment();
    }

    public int getIdent() {
        return this.xlsStyle.getIndention();
    }

    public int getRotation() {
        return this.xlsStyle.getRotation();
    }

    public String getTextFormat() {
        return this.xlsStyle.getDataFormatString();
    }

    public int getVerticalAlignment() {
        return this.xlsStyle == null ? 0 : (int)this.xlsStyle.getVerticalAlignment();
    }

    public boolean isWrappedText() {
        return this.xlsStyle.getWrapText();
    }

    public CellStyle getXlsStyle() {
        return this.xlsStyle;
    }

    private POIXMLDocumentPart getTheme(XSSFWorkbook wb) throws Exception {
        for (POIXMLDocumentPart p : wb.getRelations()) {
            if (!p.getPackageRelationship().getRelationshipType().equals(XSSFRelation.THEME.getRelation())) continue;
            return p;
        }
        return null;
    }

    private short[] getThemeColorRgb(int idx, double tint) throws Exception {
        float[] hsl;
        byte[] rgb;
        CTColorScheme colorScheme = this.themeDocument.getTheme().getThemeElements().getClrScheme();
        CTColor ctColor = null;
        int cnt = 0;
        for (XmlObject obj : colorScheme.selectPath("./*")) {
            if (!(obj instanceof CTColor)) continue;
            if (cnt == idx) {
                ctColor = (CTColor)obj;
                break;
            }
            ++cnt;
        }
        if (ctColor == null) {
            return null;
        }
        if (idx > 3) {
            rgb = ctColor.getSrgbClr().getVal();
            hsl = XlsCellStyle2.convertRGBtoHSL(rgb[0] & 0xFF, rgb[1] & 0xFF, rgb[2] & 0xFF);
        } else {
            rgb = ctColor.getSrgbClr() != null ? ctColor.getSrgbClr().getVal() : ctColor.getSysClr().getLastClr();
            hsl = XlsCellStyle2.convertRGBtoHSL(255 - rgb[0] & 0xFF, 255 - rgb[1] & 0xFF, 255 - rgb[2] & 0xFF);
        }
        float lightness = tint > 0.0 ? (float)Math.min(1.0, Math.max(0.0, (double)hsl[2] * (1.0 - tint) + tint)) : (tint == 0.0 ? hsl[2] : (float)Math.min(1.0, Math.max(0.0, (double)hsl[2] * (1.0 + tint))));
        return XlsCellStyle2.convertHSLtoRGB(hsl[0], hsl[1], lightness);
    }

    private static float[] convertRGBtoHSL(int r, int g, int b) {
        float S;
        float var_Max;
        float var_Min;
        float var_R = (float)r / 255.0f;
        float var_G = (float)g / 255.0f;
        float var_B = (float)b / 255.0f;
        if (var_R > var_G) {
            var_Min = var_G;
            var_Max = var_R;
        } else {
            var_Min = var_R;
            var_Max = var_G;
        }
        if (var_B > var_Max) {
            var_Max = var_B;
        }
        if (var_B < var_Min) {
            var_Min = var_B;
        }
        float del_Max = var_Max - var_Min;
        float H = 0.0f;
        float L = (var_Max + var_Min) / 2.0f;
        if (del_Max == 0.0f) {
            H = 0.0f;
            S = 0.0f;
        } else {
            S = (double)L < 0.5 ? del_Max / (var_Max + var_Min) : del_Max / (2.0f - var_Max - var_Min);
            float del_R = ((var_Max - var_R) / 6.0f + del_Max / 2.0f) / del_Max;
            float del_G = ((var_Max - var_G) / 6.0f + del_Max / 2.0f) / del_Max;
            float del_B = ((var_Max - var_B) / 6.0f + del_Max / 2.0f) / del_Max;
            if (var_R == var_Max) {
                H = del_B - del_G;
            } else if (var_G == var_Max) {
                H = 0.33333334f + del_R - del_B;
            } else if (var_B == var_Max) {
                H = 0.6666667f + del_G - del_R;
            }
            if (H < 0.0f) {
                H += 1.0f;
            }
            if (H > 1.0f) {
                H -= 1.0f;
            }
        }
        return new float[]{H * 360.0f, S, L};
    }

    private static short[] convertHSLtoRGB(float h, float s, float l) {
        float q = (double)l < 0.5 ? l * (1.0f + s) : l + s - l * s;
        float p = 2.0f * l - q;
        float hNorm = h / 360.0f;
        float tR = hNorm + 0.3333333f;
        float tG = hNorm;
        float tB = hNorm - 0.3333333f;
        float r = XlsCellStyle2.convertHueToRGB(tR, p, q);
        float g = XlsCellStyle2.convertHueToRGB(tG, p, q);
        float b = XlsCellStyle2.convertHueToRGB(tB, p, q);
        Color rgbColor = new Color(r, g, b);
        return new short[]{(short)rgbColor.getRed(), (short)rgbColor.getGreen(), (short)rgbColor.getBlue()};
    }

    private static float convertHueToRGB(float tC, float p, float q) {
        if (tC < 0.0f) {
            tC += 1.0f;
        }
        if (tC > 1.0f) {
            tC -= 1.0f;
        }
        float retVal = 6.0f * tC < 1.0f ? p + (q - p) * 6.0f * tC : (2.0f * tC < 1.0f ? q : (3.0f * tC < 2.0f ? p + (q - p) * 6.0f * (0.6666667f - tC) : p));
        return retVal;
    }
}

