/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls;

import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.openl.rules.table.GridRegion;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.xls.PoiExcelHelper;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.util.export.ExportException;
import org.openl.util.export.IExportRow;
import org.openl.util.export.IExportSection;
import org.openl.util.export.IExportable;
import org.openl.util.export.IExporter;

public class XlsSheetGridExporter
implements IExporter {
    public static final String SHEET_NAME = "Saved Searches";
    private final XlsSheetGridModel gridModel;
    private CellStyle headerStyle;
    private CellStyle style;
    private final Workbook workbook;

    private static int height(IExportSection section) {
        IExportRow[] rows;
        int height = 0;
        IExportSection[] subSections = section.getSubSections();
        if (subSections != null) {
            for (IExportSection subSection : subSections) {
                height += XlsSheetGridExporter.height(subSection);
            }
        }
        if ((rows = section.getRows()) != null) {
            height += rows.length;
        }
        return height == 0 ? 1 : height;
    }

    private static int width(IExportSection section) {
        IExportRow[] rows;
        int width = 0;
        IExportSection[] subSections = section.getSubSections();
        if (subSections != null) {
            for (IExportSection subSection : subSections) {
                width = Math.max(width, XlsSheetGridExporter.width(subSection));
            }
        }
        if ((rows = section.getRows()) != null) {
            for (IExportRow row : rows) {
                width = Math.max(width, row.size());
            }
        }
        return width + 1;
    }

    public XlsSheetGridExporter(Workbook workbook, XlsSheetGridModel xlsSheetGridModel) {
        this.workbook = workbook;
        this.gridModel = xlsSheetGridModel;
    }

    public XlsSheetGridExporter(XlsSheetGridModel gridModel) {
        if (gridModel == null) {
            throw new NullPointerException("gridModel is null");
        }
        this.gridModel = gridModel;
        this.workbook = gridModel.getSheetSource().getWorkbookSource().getWorkbook();
    }

    private void fillCell(int col, int row, int height, String value) {
        this.gridModel.setCellValue(col, row, value);
        CellStyle style = this.getStyle();
        for (int r = 0; r < height; ++r) {
            PoiExcelHelper.getOrCreateCell(col, row + r, this.gridModel.getSheetSource().getSheet()).setCellStyle(style);
        }
    }

    private void fillCellStretchHorizontally(int col, int row, int width, String value) {
        if (width == 1) {
            this.fillCell(col, row, 1, value);
        } else {
            this.gridModel.setCellValue(col, row, value);
            CellStyle style = this.getStyle();
            for (int c = 0; c < width; ++c) {
                PoiExcelHelper.getOrCreateCell(col + c, row, this.gridModel.getSheetSource().getSheet()).setCellStyle(style);
            }
        }
    }

    CellStyle getHeaderStyle() {
        if (this.headerStyle == null) {
            CellStyle cellStyle = this.workbook.createCellStyle();
            cellStyle.setBorderBottom((short)1);
            cellStyle.setBorderTop((short)1);
            cellStyle.setBorderLeft((short)1);
            cellStyle.setBorderRight((short)1);
            cellStyle.setFillForegroundColor((short)8);
            cellStyle.setFillPattern((short)1);
            Font font = this.workbook.createFont();
            font.setColor((short)9);
            font.setBoldweight((short)700);
            cellStyle.setFont(font);
            this.headerStyle = cellStyle;
        }
        return this.headerStyle;
    }

    private CellStyle getStyle() {
        if (this.style == null) {
            CellStyle cellStyle = this.workbook.createCellStyle();
            cellStyle.setBorderBottom((short)1);
            cellStyle.setBorderTop((short)1);
            cellStyle.setBorderLeft((short)1);
            cellStyle.setBorderRight((short)1);
            this.style = cellStyle;
        }
        return this.style;
    }

    public void persist(IExportable exportable) throws ExportException {
        int height;
        IExportSection exportSection = exportable.mainSection();
        int width = XlsSheetGridExporter.width(exportSection);
        IGridRegion region = this.gridModel.findEmptyRect(width, height = XlsSheetGridExporter.height(exportSection) + 1);
        if (region == null) {
            throw new ExportException("could not find appropriate region for writing");
        }
        this.gridModel.addMergedRegion(new GridRegion(region.getTop(), region.getLeft(), region.getTop(), region.getRight()));
        this.persistHeader(region, "Persistent " + exportable.getClass().getName());
        this.persist(region.getLeft(), region.getTop() + 1, exportSection, width);
    }

    private int persist(int col, int row, IExportSection section, int widthToFill) {
        IExportRow[] rows;
        int height = 0;
        ++col;
        --widthToFill;
        IExportSection[] subSections = section.getSubSections();
        if (subSections != null) {
            for (IExportSection subSection : subSections) {
                height += this.persist(col, row + height, subSection, widthToFill);
            }
        }
        if ((rows = section.getRows()) != null) {
            for (IExportRow expRrow : rows) {
                this.persistRow(col, row + height++, expRrow, widthToFill);
            }
        }
        --col;
        if (height > 1) {
            this.gridModel.addMergedRegion(new GridRegion(row, col, row + height - 1, col));
        }
        this.fillCell(col, row, height, section.getName());
        return height == 0 ? 1 : height;
    }

    private void persistHeader(IGridRegion region, String text) {
        this.gridModel.setCellValue(region.getLeft(), region.getTop(), text);
        CellStyle hstyle = this.getHeaderStyle();
        for (int col = region.getLeft(); col <= region.getRight(); ++col) {
            PoiExcelHelper.getOrCreateCell(col, region.getTop(), this.gridModel.getSheetSource().getSheet()).setCellStyle(hstyle);
        }
    }

    private void persistRow(int col, int row, IExportRow expRrow, int widthToFill) {
        if (expRrow.size() >= widthToFill) {
            for (String cell : expRrow.record()) {
                this.fillCell(col++, row, 1, cell);
            }
        } else {
            String[] cells = expRrow.record();
            for (int i = 0; i < cells.length - 1; ++i) {
                this.fillCell(col++, row, 1, cells[i]);
            }
            int width = widthToFill - cells.length + 1;
            this.gridModel.addMergedRegion(new GridRegion(row, col, row, col + width - 1));
            this.fillCellStretchHorizontally(col, row, width, cells[cells.length - 1]);
        }
    }
}

