/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.lang.xls.XlsWorkbookSourceCodeModule;
import org.openl.rules.table.xls.XlsSheetGridExporter;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.FileSourceCodeModule;
import org.openl.util.export.IExporter;

public class XlsSheetGridHelper {
    private static String VIRTUAL_EXCEL_FILE = "/VIRTUAL_EXCEL_FILE.xls";

    private XlsSheetGridHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IExporter createExporter(XlsWorkbookSourceCodeModule workbookModule) {
        Sheet sheet;
        Workbook workbook;
        Workbook workbook2 = workbook = workbookModule.getWorkbook();
        synchronized (workbook2) {
            sheet = workbook.getSheet("Saved Searches");
            if (sheet == null) {
                sheet = workbook.createSheet("Saved Searches");
            }
        }
        return new XlsSheetGridExporter(workbook, XlsSheetGridHelper.createVirtualGrid(sheet));
    }

    public static XlsSheetGridModel createVirtualGrid(Sheet sheet) {
        String virtualExcelFile = XlsSheetGridHelper.getDefaultFileName(sheet);
        return XlsSheetGridHelper.createVirtualGrid(sheet, virtualExcelFile);
    }

    public static XlsSheetGridModel createVirtualGrid(Sheet sheet, String virtualExcelFile) {
        if (StringUtils.isBlank((String)virtualExcelFile)) {
            virtualExcelFile = XlsSheetGridHelper.getDefaultFileName(sheet);
        }
        XlsWorkbookSourceCodeModule mockWorkbookSource = new XlsWorkbookSourceCodeModule((IOpenSourceCodeModule)new FileSourceCodeModule(virtualExcelFile, null), sheet.getWorkbook());
        XlsSheetSourceCodeModule mockSheetSource = new XlsSheetSourceCodeModule(sheet, sheet.getSheetName(), mockWorkbookSource);
        return new XlsSheetGridModel(mockSheetSource);
    }

    private static String getDefaultFileName(Sheet sheet) {
        return String.format("%s%s", sheet.getSheetName(), VIRTUAL_EXCEL_FILE);
    }
}

