/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls;

import java.util.ArrayList;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.GridRegion;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.util.export.IImportedSection;
import org.openl.util.export.IImporter;
import org.openl.util.export.ImportedSection;

public class XlsSheetGridImporter
implements IImporter {
    private IGridRegion region;
    private XlsSheetGridModel gridModel;

    public XlsSheetGridImporter(XlsSheetGridModel gridModel, TableSyntaxNode node) {
        this.gridModel = gridModel;
        this.region = node.getGridTable().getRegion();
        this.region = new GridRegion(this.region.getTop() + 1, this.region.getLeft(), this.region.getBottom(), this.region.getRight());
    }

    private String[] readRow(int row, int colStart, int colEnd) {
        ArrayList<String> rowData = new ArrayList<String>();
        for (int c = colStart; c <= colEnd; c += this.gridModel.getCell(row, c).getWidth()) {
            rowData.add(this.gridModel.getCell(c, row).getStringValue());
        }
        return rowData.toArray(new String[rowData.size()]);
    }

    public String[][] readRows(Object parentSectionId) {
        if (parentSectionId == null) {
            return null;
        }
        SectionId id = (SectionId)parentSectionId;
        int column = id.column;
        int row = id.row;
        ICell cell = this.gridModel.getCell(column, row);
        int height = cell.getHeight();
        column += cell.getWidth();
        ArrayList<String[]> rows = new ArrayList<String[]>();
        for (int r = row; r < row + height; ++r) {
            rows.add(this.readRow(r, column, this.region.getRight()));
        }
        return (String[][])rows.toArray((T[])new String[rows.size()][]);
    }

    public IImportedSection[] readSections(Object parentSectionId) {
        int height;
        int row;
        int column;
        if (parentSectionId == null) {
            column = this.region.getLeft();
            row = this.region.getTop();
            height = this.region.getBottom() - this.region.getTop() + 1;
        } else {
            SectionId id = (SectionId)parentSectionId;
            column = id.column;
            row = id.row;
            ICell cell = this.gridModel.getCell(column, row);
            height = cell.getHeight();
            column += cell.getWidth();
        }
        ArrayList<ImportedSection> sections = new ArrayList<ImportedSection>();
        for (int r = row; r < row + height; r += this.gridModel.getCell(column, r).getHeight()) {
            sections.add(new ImportedSection((Object)new SectionId(column, r), this.gridModel.getCell(column, r).getStringValue()));
        }
        return sections.toArray(new IImportedSection[sections.size()]);
    }

    private static class SectionId {
        private int column;
        private int row;

        private SectionId(int column, int row) {
            this.column = column;
            this.row = row;
        }
    }
}

