/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.openl.domain.EnumDomain;
import org.openl.domain.IDomain;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.lang.xls.XlsWorkbookSourceCodeModule;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.table.AGrid;
import org.openl.rules.table.CellKey;
import org.openl.rules.table.GridRegion;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.RegionsPool;
import org.openl.rules.table.ui.ICellStyle;
import org.openl.rules.table.xls.PoiExcelHelper;
import org.openl.rules.table.xls.XlsCell;
import org.openl.rules.table.xls.XlsCellStyle;
import org.openl.rules.table.xls.XlsCellStyle2;
import org.openl.rules.table.xls.XlsGridRegion;
import org.openl.rules.table.xls.writers.AXlsCellWriter;
import org.openl.rules.table.xls.writers.XlsCellArrayWriter;
import org.openl.rules.table.xls.writers.XlsCellBooleanWriter;
import org.openl.rules.table.xls.writers.XlsCellDateWriter;
import org.openl.rules.table.xls.writers.XlsCellEnumArrayWriter;
import org.openl.rules.table.xls.writers.XlsCellEnumWriter;
import org.openl.rules.table.xls.writers.XlsCellFormulaWriter;
import org.openl.rules.table.xls.writers.XlsCellNumberWriter;
import org.openl.rules.table.xls.writers.XlsCellStringWriter;
import org.openl.types.IOpenClass;
import org.openl.util.EnumUtils;

public class XlsSheetGridModel
extends AGrid
implements IWritableGrid,
XlsWorkbookSourceCodeModule.WorkbookListener {
    private XlsSheetSourceCodeModule sheetSource;
    private Sheet sheet;
    private RegionsPool mergedRegionsPool;
    private Map<CellKey, CellMetaInfo> metaInfoMap = new HashMap<CellKey, CellMetaInfo>();
    private Map<String, AXlsCellWriter> cellWriters = new HashMap<String, AXlsCellWriter>();

    @Deprecated
    public static int getColumn(String cell) {
        return IGridRegion.Tool.getColumn(cell);
    }

    @Deprecated
    public static int getRow(String cell) {
        return IGridRegion.Tool.getRow(cell);
    }

    @Deprecated
    public static IGridRegion makeRegion(String range) {
        return IGridRegion.Tool.makeRegion(range);
    }

    protected XlsSheetGridModel(Sheet sheet) {
        this.sheet = sheet;
        this.extractMergedRegions();
        this.initCellWriters();
    }

    public XlsSheetGridModel(XlsSheetSourceCodeModule sheetSource) {
        this.sheetSource = sheetSource;
        this.sheet = sheetSource.getSheet();
        this.extractMergedRegions();
        sheetSource.getWorkbookSource().addListener(this);
        this.initCellWriters();
    }

    private void extractMergedRegions() {
        this.mergedRegionsPool = new RegionsPool(null);
        int nregions = this.getNumberOfMergedRegions();
        for (int i = 0; i < nregions; ++i) {
            CellRangeAddress reg = PoiExcelHelper.getMergedRegionAt(i, this.sheet);
            this.mergedRegionsPool.add(new XlsGridRegion(reg));
        }
    }

    private void initCellWriters() {
        this.cellWriters.put("Array Writer", new XlsCellArrayWriter(this));
        this.cellWriters.put("Boolean Writer", new XlsCellBooleanWriter(this));
        this.cellWriters.put("Date Writer", new XlsCellDateWriter(this));
        this.cellWriters.put("Enum Array Writer", new XlsCellEnumArrayWriter(this));
        this.cellWriters.put("Enum Writer", new XlsCellEnumWriter(this));
        this.cellWriters.put("Formula Writer", new XlsCellFormulaWriter(this));
        this.cellWriters.put("Number Writer", new XlsCellNumberWriter(this));
        this.cellWriters.put("String Writer", new XlsCellStringWriter(this));
    }

    public int addMergedRegion(IGridRegion reg) {
        Object topLeftCellValue = this.findFirstValueInRegion(reg);
        for (int row = reg.getTop(); row <= reg.getBottom(); ++row) {
            for (int column = reg.getLeft(); column <= reg.getRight(); ++column) {
                if (column == reg.getLeft() && row == reg.getTop()) continue;
                this.clearCellValue(column, row);
            }
        }
        this.setCellValue(reg.getLeft(), reg.getTop(), topLeftCellValue);
        this.mergedRegionsPool.add(reg);
        return this.sheet.addMergedRegion(new CellRangeAddress(reg.getTop(), reg.getBottom(), reg.getLeft(), reg.getRight()));
    }

    private Object findFirstValueInRegion(IGridRegion reg) {
        for (int row = reg.getTop(); row <= reg.getBottom(); ++row) {
            for (int column = reg.getLeft(); column <= reg.getRight(); ++column) {
                Object cellValue = this.getCell(column, row).getObjectValue();
                if (cellValue == null) continue;
                return cellValue;
            }
        }
        return null;
    }

    public void beforeSave(XlsWorkbookSourceCodeModule xwscm) {
    }

    public void clearCellValue(int col, int row) {
        this.setCellValue(col, row, null);
    }

    public void clearCell(int col, int row) {
        this.setCellMetaInfo(col, row, null);
        Cell cell = PoiExcelHelper.getCell(col, row, this.sheet);
        if (cell != null) {
            this.sheet.getRow(row).removeCell(cell);
        }
    }

    public void copyCell(int colFrom, int rowFrom, int colTo, int rowTo) {
        Cell cellFrom = PoiExcelHelper.getCell(colFrom, rowFrom, this.sheet);
        this.copyCell(cellFrom, colTo, rowTo, this.getCellMetaInfo(colFrom, rowFrom));
    }

    public void createCell(int col, int row, Object value, String formula, ICellStyle style) {
        if (StringUtils.isNotBlank((String)formula)) {
            this.setCellFormula(col, row, formula);
        } else {
            this.setCellValue(col, row, value);
        }
        this.setCellStyle(col, row, style);
        this.setCellMetaInfo(col, row, this.getCellMetaInfo(col, row));
    }

    protected void copyCell(Cell cellFrom, int colTo, int rowTo, CellMetaInfo meta) {
        Cell cellTo = PoiExcelHelper.getCell(colTo, rowTo, this.sheet);
        if (cellFrom == null) {
            if (cellTo != null) {
                this.clearCell(colTo, rowTo);
            }
            return;
        }
        if (cellTo == null) {
            cellTo = PoiExcelHelper.getOrCreateCell(colTo, rowTo, this.sheet);
        }
        PoiExcelHelper.copyCellValue(cellFrom, cellTo);
        PoiExcelHelper.copyCellStyle(cellFrom, cellTo, this.sheet);
        this.setCellMetaInfo(colTo, rowTo, meta);
    }

    public IGridRegion findEmptyRect(int width, int height) {
        int lastRow = PoiExcelHelper.getLastRowNum(this.sheet);
        int top = lastRow + 2;
        int left = 1;
        return new GridRegion(top, left, top + height - 1, left + width - 1);
    }

    @Deprecated
    public Cell getXlsCell(int colIndex, int rowIndex) {
        return PoiExcelHelper.getCell(colIndex, rowIndex, this.sheet);
    }

    @Deprecated
    public Cell getOrCreateXlsCell(int colIndex, int rowIndex) {
        return PoiExcelHelper.getOrCreateCell(colIndex, rowIndex, this.sheet);
    }

    public ICell getCell(int column, int row) {
        return new XlsCell(column, row, this);
    }

    protected CellMetaInfo getCellMetaInfo(int col, int row) {
        CellKey ck = new CellKey(col, row);
        return this.metaInfoMap.get(ck);
    }

    public int getColumnWidth(int col) {
        return PoiExcelHelper.getColumnWidth(col, this.sheet);
    }

    public int getMaxColumnIndex(int rownum) {
        return PoiExcelHelper.getMaxColumnIndex(rownum, this.sheet);
    }

    public int getMaxRowIndex() {
        return PoiExcelHelper.getMaxRowIndex(this.sheet);
    }

    public synchronized IGridRegion getMergedRegion(int i) {
        return new XlsGridRegion(PoiExcelHelper.getMergedRegionAt(i, this.sheet));
    }

    public int getMinColumnIndex(int rownum) {
        return PoiExcelHelper.getMinColumnIndex(rownum, this.sheet);
    }

    public int getMinRowIndex() {
        return PoiExcelHelper.getMinRowIndex(this.sheet);
    }

    public String getName() {
        return this.sheetSource.getSheetName();
    }

    public int getNumberOfMergedRegions() {
        return PoiExcelHelper.getNumberOfMergedRegions(this.sheet);
    }

    public String getRangeUri(int colStart, int rowStart, int colEnd, int rowEnd) {
        if (colStart == colEnd && rowStart == rowEnd) {
            return this.getUri() + "&" + "cell=" + this.getCell(colStart, rowStart).getUri();
        }
        return this.getUri() + "&" + "range=" + this.getCell(colStart, rowStart).getUri() + ":" + this.getCell(colEnd, rowEnd).getUri();
    }

    public String getRangeUri(IGridRegion region) {
        return this.getRangeUri(region.getLeft(), region.getTop(), region.getRight(), region.getBottom());
    }

    public IGridRegion getRegionContaining(int x, int y) {
        return this.mergedRegionsPool.getRegionContaining(x, y);
    }

    @Deprecated
    public static boolean contains(CellRangeAddress reg, int x, int y) {
        return reg.getFirstColumn() <= x && x <= reg.getLastColumn() && reg.getFirstRow() <= y && y <= reg.getLastRow();
    }

    public XlsSheetSourceCodeModule getSheetSource() {
        return this.sheetSource;
    }

    public String getUri() {
        String xlsUri = this.sheetSource == null ? "" : this.sheetSource.getUri(0);
        return xlsUri;
    }

    public boolean isEmpty(int x, int y) {
        return PoiExcelHelper.isEmptyCell(x, y, this.sheet);
    }

    public void removeMergedRegion(IGridRegion remove) {
        this.removeMergedRegion(remove.getLeft(), remove.getTop());
    }

    public void removeMergedRegion(int x, int y) {
        this.mergedRegionsPool.remove(x, y);
        int nregions = this.getNumberOfMergedRegions();
        for (int i = 0; i < nregions; ++i) {
            CellRangeAddress reg = PoiExcelHelper.getMergedRegionAt(i, this.sheet);
            if (reg.getFirstColumn() != x || reg.getFirstRow() != y) continue;
            this.sheet.removeMergedRegion(i);
            if (this.sheet instanceof XSSFSheet && this.sheet.getNumMergedRegions() == 0) {
                ((XSSFSheet)this.sheet).getCTWorksheet().unsetMergeCells();
            }
            return;
        }
    }

    public void setCellMetaInfo(int col, int row, CellMetaInfo meta) {
        CellKey ck = new CellKey(col, row);
        if (meta == null) {
            this.metaInfoMap.remove(ck);
        } else {
            this.metaInfoMap.put(ck, meta);
        }
    }

    public void setCellStringValue(int col, int row, String value) {
        PoiExcelHelper.setCellStringValue(col, row, value, this.sheet);
    }

    public void setCellStyle(int col, int row, ICellStyle style) {
        Cell poiCell = PoiExcelHelper.getOrCreateCell(col, row, this.sheet);
        CellStyle newPoiStyle = this.sheet.getWorkbook().createCellStyle();
        CellStyle styleToClone = null;
        styleToClone = style instanceof XlsCellStyle ? ((XlsCellStyle)style).getXlsStyle() : (style instanceof XlsCellStyle2 ? ((XlsCellStyle2)style).getXlsStyle() : poiCell.getCellStyle());
        newPoiStyle.cloneStyleFrom(styleToClone);
        XlsSheetGridModel.styleToXls(style, newPoiStyle);
        poiCell.setCellStyle(newPoiStyle);
    }

    public static void styleToXls(ICellStyle source, CellStyle dest) {
        if (source != null && dest != null) {
            dest.setAlignment((short)source.getHorizontalAlignment());
            dest.setVerticalAlignment((short)source.getVerticalAlignment());
            dest.setIndention((short)source.getIdent());
            short[] bs = source.getBorderStyle();
            dest.setBorderTop(bs[0]);
            dest.setBorderRight(bs[1]);
            dest.setBorderBottom(bs[2]);
            dest.setBorderLeft(bs[3]);
        }
    }

    public void setCellValue(int col, int row, Object value) {
        Cell poiCell = PoiExcelHelper.getOrCreateCell(col, row, this.sheet);
        if (value != null) {
            boolean writeCellMetaInfo = true;
            if (this.hasPredefinedStringArray(col, row)) {
                writeCellMetaInfo = false;
            }
            AXlsCellWriter cellWriter = this.getCellWriter(poiCell.getCellType(), value);
            cellWriter.setCellToWrite(poiCell);
            cellWriter.setValueToWrite(value);
            cellWriter.writeCellValue(writeCellMetaInfo);
        } else {
            poiCell.setCellType(3);
        }
    }

    public void setCellFormula(int col, int row, String formula) {
        Cell poiCell = PoiExcelHelper.getOrCreateCell(col, row, this.sheet);
        if (formula != null) {
            AXlsCellWriter cellWriter = this.cellWriters.get("Formula Writer");
            cellWriter.setCellToWrite(poiCell);
            cellWriter.setValueToWrite(formula);
            cellWriter.writeCellValue(false);
        }
    }

    public boolean hasPredefinedStringArray(int col, int row) {
        boolean result = false;
        ICell cell = this.getCell(col, row);
        if (cell != null) {
            IOpenClass dataType;
            CellMetaInfo cellMetaInfo = cell.getMetaInfo();
            IOpenClass iOpenClass = dataType = cellMetaInfo == null ? null : cellMetaInfo.getDataType();
            if (dataType != null) {
                IDomain domain = dataType.getDomain();
                Class instanceClass = dataType.getInstanceClass();
                if (instanceClass == String.class && domain instanceof EnumDomain) {
                    result = true;
                }
            }
        }
        return result;
    }

    public AXlsCellWriter getCellWriter(int cellType, Object value) {
        String strValue;
        AXlsCellWriter result = null;
        result = value instanceof Number ? this.cellWriters.get("Number Writer") : (value instanceof Date ? this.cellWriters.get("Date Writer") : (value instanceof Boolean ? this.cellWriters.get("Boolean Writer") : (EnumUtils.isEnum((Object)value) ? this.cellWriters.get("Enum Writer") : (EnumUtils.isEnumArray((Object)value) ? this.cellWriters.get("Enum Array Writer") : (value.getClass().isArray() ? this.cellWriters.get("Array Writer") : ((strValue = String.valueOf(value)).startsWith("=") && cellType == 2 ? this.cellWriters.get("Formula Writer") : this.cellWriters.get("String Writer")))))));
        return result;
    }
}

