/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls.builder;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;
import org.openl.rules.table.GridRegion;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ui.ICellStyle;
import org.openl.rules.table.xls.PoiExcelHelper;
import org.openl.rules.table.xls.XlsCellStyle;
import org.openl.rules.table.xls.XlsCellStyle2;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.rules.table.xls.builder.CreateTableException;
import org.openl.rules.table.xls.formatters.XlsDateFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableBuilder {
    public static final String TABLE_PROPERTIES = "properties";
    public static final String TABLE_PROPERTIES_NAME = "name";
    public static final int HEADER_HEIGHT = 1;
    public static final int PROPERTIES_MIN_WIDTH = 3;
    private final XlsSheetGridModel gridModel;
    private IGridRegion region;
    private int width;
    private int height;
    private int currentRow;
    private CellStyle defaultCellStyle;
    private Map<CellStyle, CellStyle> style2style;

    public TableBuilder(XlsSheetGridModel gridModel) {
        if (gridModel == null) {
            throw new IllegalArgumentException("gridModel is null");
        }
        this.gridModel = gridModel;
        this.style2style = new HashMap<CellStyle, CellStyle>();
    }

    public void beginTable(int width, int height) throws CreateTableException {
        if (this.region != null) {
            throw new IllegalStateException("beginTable() has already been called");
        }
        this.width = width;
        this.height = height;
        this.region = this.gridModel.findEmptyRect(width, height);
        if (this.region == null) {
            throw new CreateTableException("could not find appropriate region for writing");
        }
        this.currentRow = 0;
        this.style2style.clear();
    }

    public void beginTable(IGridRegion regionToWrite) throws CreateTableException {
        if (this.region != null) {
            throw new IllegalStateException("beginTable() has already been called");
        }
        this.region = regionToWrite;
        if (this.region == null) {
            throw new CreateTableException("could not find appropriate region for writing");
        }
        this.currentRow = 0;
        this.style2style.clear();
    }

    public void endTable() throws CreateTableException {
        if (this.region == null) {
            throw new IllegalStateException("endTable() call without prior beginTable() call");
        }
        for (int y = this.currentRow; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.writeCell(x, y, 1, 1, "");
            }
        }
        this.region = null;
        this.style2style.clear();
    }

    public void save() throws CreateTableException {
        try {
            this.gridModel.getSheetSource().getWorkbookSource().save();
        }
        catch (IOException e) {
            throw new CreateTableException("\u043f\u0457\u0405ould not save table. " + e.getMessage());
        }
    }

    protected int getCurrentRow() {
        return this.currentRow;
    }

    protected CellStyle getDefaultCellStyle() {
        if (this.defaultCellStyle == null) {
            Workbook workbook = this.gridModel.getSheetSource().getWorkbookSource().getWorkbook();
            CellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setBorderBottom((short)1);
            cellStyle.setBorderTop((short)1);
            cellStyle.setBorderLeft((short)1);
            cellStyle.setBorderRight((short)1);
            this.defaultCellStyle = cellStyle;
        }
        return this.defaultCellStyle;
    }

    protected XlsSheetGridModel getGridModel() {
        return this.gridModel;
    }

    protected int getHeight() {
        return this.height;
    }

    public IGridRegion getTableRegion() {
        return this.region;
    }

    protected int getWidth() {
        return this.width;
    }

    protected void incCurrentRow() {
        this.incCurrentRow(1);
    }

    protected void incCurrentRow(int increment) {
        this.currentRow += increment;
    }

    protected void writeCell(int x, int y, int width, int height, Object value) {
        this.writeCell(x, y, width, height, value, null);
    }

    protected void writeCell(int x, int y, int width, int height, Object value, ICellStyle style) {
        CellStyle cellStyle = this.analyseCellStyle(style);
        x += this.region.getLeft();
        y += this.region.getTop();
        if (width == 1 && height == 1) {
            Cell cell = PoiExcelHelper.getOrCreateCell(x, y, this.gridModel.getSheetSource().getSheet());
            this.gridModel.setCellValue(x, y, value);
            if (value instanceof Date) {
                cellStyle = null;
                cellStyle = this.getDateCellStyle(cell);
            }
            this.setCellStyle(cell, cellStyle);
        } else {
            int x2 = x + width - 1;
            int y2 = y + height - 1;
            this.gridModel.addMergedRegion(new GridRegion(y, x, y2, x2));
            for (int col = x; col <= x2; ++col) {
                for (int row = y; row <= y2; ++row) {
                    Cell newCell = PoiExcelHelper.getOrCreateCell(col, row, this.gridModel.getSheetSource().getSheet());
                    this.gridModel.setCellValue(x, y, value);
                    this.setCellStyle(newCell, cellStyle);
                }
            }
        }
    }

    private CellStyle analyseCellStyle(ICellStyle style) {
        CellStyle returnStyle = null;
        if (style != null) {
            if (style instanceof XlsCellStyle) {
                returnStyle = ((XlsCellStyle)style).getXlsStyle();
            } else if (style instanceof XlsCellStyle2) {
                returnStyle = ((XlsCellStyle2)style).getXlsStyle();
            }
        } else {
            returnStyle = this.getDefaultCellStyle();
        }
        return returnStyle;
    }

    private CellStyle getDateCellStyle(Cell cell) {
        CellStyle previousStyle = cell.getCellStyle();
        cell.setCellStyle(cell.getSheet().getWorkbook().createCellStyle());
        cell.getCellStyle().cloneStyleFrom(previousStyle);
        cell.getCellStyle().setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)XlsDateFormatter.DEFAULT_XLS_DATE_FORMAT));
        return cell.getCellStyle();
    }

    private void setCellStyle(Cell cell, CellStyle cellStyle) {
        CellStyle newStyle = this.style2style.get(cellStyle);
        if (newStyle != null) {
            cellStyle = newStyle;
        }
        try {
            cell.setCellStyle(cellStyle);
        }
        catch (Exception e) {
            CellStyle style = this.findWorkbookCellStyle(cellStyle);
            if (style != null) {
                this.style2style.put(cellStyle, style);
            } else {
                Workbook workbook = this.gridModel.getSheetSource().getWorkbookSource().getWorkbook();
                style = workbook.createCellStyle();
                try {
                    style.cloneStyleFrom(cellStyle);
                }
                catch (IllegalArgumentException ex) {
                    // empty catch block
                }
                this.style2style.put(cellStyle, style);
            }
            cell.setCellStyle(style);
        }
    }

    private CellStyle findWorkbookCellStyle(CellStyle cellStyle) {
        Workbook workbook = this.gridModel.getSheetSource().getWorkbookSource().getWorkbook();
        int numCellStyles = workbook.getNumCellStyles();
        for (int i = 0; i < numCellStyles; ++i) {
            CellStyle cellStyleAt = workbook.getCellStyleAt((short)i);
            if (!this.equalsStyle(cellStyleAt, cellStyle)) continue;
            return cellStyleAt;
        }
        return null;
    }

    private boolean equalsStyle(CellStyle cs1, CellStyle cs2) {
        return cs1.getAlignment() == cs2.getAlignment() && cs1.getAlignment() == cs2.getAlignment() && cs1.getHidden() == cs2.getHidden() && cs1.getLocked() == cs2.getLocked() && cs1.getWrapText() == cs2.getWrapText() && cs1.getBorderBottom() == cs2.getBorderBottom() && cs1.getBorderLeft() == cs2.getBorderLeft() && cs1.getBorderRight() == cs2.getBorderRight() && cs1.getBorderTop() == cs2.getBorderTop() && cs1.getBottomBorderColor() == cs2.getBottomBorderColor() && cs1.getFillBackgroundColor() == cs2.getFillBackgroundColor() && cs1.getFillForegroundColor() == cs2.getFillForegroundColor() && cs1.getFillPattern() == cs2.getFillPattern() && cs1.getIndention() == cs2.getIndention() && cs1.getLeftBorderColor() == cs2.getLeftBorderColor() && cs1.getRightBorderColor() == cs2.getRightBorderColor() && cs1.getRotation() == cs2.getRotation() && cs1.getTopBorderColor() == cs2.getTopBorderColor() && cs1.getVerticalAlignment() == cs2.getVerticalAlignment() && cs1.getDataFormat() == cs2.getDataFormat();
    }

    protected void writeCell(int x, int y, Object value) {
        this.writeCell(x, y, 1, 1, value, null);
    }

    public void writeGridTable(IGridTable table) {
        if (table == null) {
            throw new IllegalArgumentException("table must be not null");
        }
        if (this.region == null) {
            throw new IllegalStateException("beginTable() has to be called");
        }
        for (int i = 0; i < table.getWidth(); ++i) {
            for (int j = 0; j < table.getHeight(); ++j) {
                ICell cell = table.getCell(i, j);
                int cellWidth = cell.getWidth();
                int cellHeight = cell.getHeight();
                Object cellValue = cell.getObjectValue();
                ICellStyle style = cell.getStyle();
                this.writeCell(i, this.currentRow + j, cellWidth, cellHeight, cellValue, style);
            }
        }
        this.currentRow += table.getHeight();
    }

    public void writeHeader(String header, ICellStyle style) {
        if (this.region == null) {
            throw new IllegalStateException("beginTable() has to be called");
        }
        this.writeCell(0, this.currentRow++, this.width, 1, header, style);
    }

    public void writeProperties(Map<String, Object> properties, ICellStyle style) {
        if (properties == null) {
            throw new IllegalArgumentException("properties must be not null");
        }
        if (this.region == null) {
            throw new IllegalStateException("beginTable() has to be called");
        }
        this.writeCell(0, this.currentRow, 1, properties.size(), TABLE_PROPERTIES, style);
        Set<String> keys = properties.keySet();
        for (String key : keys) {
            this.writeCell(1, this.currentRow, 1, 1, key, style);
            Object value = properties.get(key);
            this.writeCell(2, this.currentRow, 1, 1, value, style);
            ++this.currentRow;
        }
    }
}

