/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls.builder;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.rules.table.xls.builder.TableBuilder;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenMember;
import org.openl.types.impl.AMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestTableBuilder
extends TableBuilder {
    private static final String RESULT_PARAM_TITLE = "Result";
    private static final String TESTMETHOD_NAME_POSTFIX = "Test";

    public TestTableBuilder(XlsSheetGridModel gridModel) {
        super(gridModel);
    }

    private static AMethod getExecutableMethod(TableSyntaxNode executableTsn) {
        if (executableTsn == null) {
            throw new IllegalArgumentException("Syntax node is null");
        }
        if (!executableTsn.isExecutableNode()) {
            throw new IllegalArgumentException("Syntax node is not executable node");
        }
        IOpenMember member = executableTsn.getMember();
        if (member != null) {
            return (AMethod)member;
        }
        return null;
    }

    public static String getHeader(TableSyntaxNode executableNode, String technicalName) {
        String result = null;
        AMethod executableMethod = TestTableBuilder.getExecutableMethod(executableNode);
        if (executableMethod != null) {
            String tableName = executableMethod.getName();
            result = technicalName != null && !"".equals(technicalName) ? "Testmethod " + tableName + " " + technicalName : "Testmethod " + tableName + " " + TestTableBuilder.getDefaultTechnicalName(executableMethod);
        }
        return result;
    }

    private static String getDefaultTechnicalName(AMethod executableMethod) {
        String tableName = executableMethod.getName();
        return tableName + TESTMETHOD_NAME_POSTFIX;
    }

    public static String getDefaultTechnicalName(TableSyntaxNode executableNode) {
        String result = null;
        AMethod executableMethod = TestTableBuilder.getExecutableMethod(executableNode);
        if (executableMethod != null) {
            result = TestTableBuilder.getDefaultTechnicalName(executableMethod);
        }
        return result;
    }

    public static Map<String, String> getParams(TableSyntaxNode executableNode) {
        AMethod executableMethod = TestTableBuilder.getExecutableMethod(executableNode);
        if (executableMethod != null) {
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            IMethodSignature tableHeaderSignature = executableMethod.getHeader().getSignature();
            for (int i = 0; i < tableHeaderSignature.getNumberOfParameters(); ++i) {
                String paramName = tableHeaderSignature.getParameterName(i);
                params.put(paramName, TestTableBuilder.id2title(paramName));
            }
            return params;
        }
        return null;
    }

    private static String id2title(String id) {
        StringBuilder sb = new StringBuilder();
        boolean space = true;
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (Character.isWhitespace(c) || c == '_') {
                if (space) continue;
                space = true;
                sb.append(" ");
                continue;
            }
            if (space || Character.isUpperCase(c)) {
                space = false;
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        if (sb.length() <= 0) {
            return id;
        }
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        return sb.toString().trim();
    }

    public void writeParams(Map<String, String> params, String resultTitle) {
        if (params == null) {
            throw new IllegalArgumentException("params must be not null");
        }
        if (this.getTableRegion() == null) {
            throw new IllegalStateException("beginTable() has to be called");
        }
        if (!params.containsKey("_res_")) {
            params.put("_res_", StringUtils.isBlank((String)resultTitle) ? RESULT_PARAM_TITLE : resultTitle);
        }
        int column = 0;
        Set<String> names = params.keySet();
        for (String name : names) {
            this.writeCell(column, this.getCurrentRow(), 1, 1, name);
            String title = params.get(name);
            this.writeCell(column, this.getCurrentRow() + 1, 1, 1, title);
            ++column;
        }
        if (!params.isEmpty()) {
            this.incCurrentRow(2);
        }
    }
}

