/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls.formatters;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.openl.rules.table.xls.formatters.AXlsFormatter;
import org.openl.util.ArrayTool;
import org.openl.util.Log;
import org.openl.util.StringTool;

public class XlsArrayFormatter
extends AXlsFormatter {
    public static final String ARRAY_ELEMENTS_SEPARATOR_ESCAPER = "\\";
    public static final String ARRAY_ELEMENTS_SEPARATOR = ",";
    private AXlsFormatter elementFormat;

    public XlsArrayFormatter(AXlsFormatter elementFormat) {
        this.elementFormat = elementFormat;
    }

    public String format(Object value) {
        String result = null;
        if (value != null) {
            if (!value.getClass().isArray()) {
                Log.error((Object)String.format("Should be an array: %s", value.toString()));
                return result;
            }
            Object[] array = ArrayTool.toArray((Object)value);
            Object[] elementResults = new String[array.length];
            for (int i = 0; i < array.length; ++i) {
                Object element = array[i];
                elementResults[i] = this.elementFormat.format(element);
                result = StringUtils.join((Object[])elementResults, (String)ARRAY_ELEMENTS_SEPARATOR);
            }
        }
        return result;
    }

    public Object parse(String value) {
        Object[] result = null;
        if (StringUtils.isNotBlank((String)value)) {
            String[] elementValues = StringTool.splitAndEscape((String)value, (String)ARRAY_ELEMENTS_SEPARATOR, (String)ARRAY_ELEMENTS_SEPARATOR_ESCAPER);
            ArrayList<Object> elements = new ArrayList<Object>();
            Class<?> elementType = null;
            for (String elementValue : elementValues) {
                Object element = this.elementFormat.parse(elementValue);
                elements.add(element);
                elementType = element.getClass();
            }
            if (elementType == null) {
                return result;
            }
            Object[] resultArray = (Object[])Array.newInstance(elementType, elements.size());
            try {
                result = elements.toArray(resultArray);
            }
            catch (ArrayStoreException e) {
                // empty catch block
            }
        }
        return result;
    }
}

