/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls.formatters;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.openl.rules.table.xls.formatters.AXlsFormatter;
import org.openl.util.Log;

public class XlsDateFormatter
extends AXlsFormatter {
    public static String DEFAULT_JAVA_DATE_FORMAT = "MM/dd/yyyy";
    public static String DEFAULT_XLS_DATE_FORMAT = "m/d/yy";
    private SimpleDateFormat format;

    public static String convertTojavaFormat(String fmt) {
        return fmt.replace('m', 'M');
    }

    public XlsDateFormatter(SimpleDateFormat fmt) {
        this.format = fmt;
    }

    public XlsDateFormatter(String fmt) {
        String javaFormat = XlsDateFormatter.convertTojavaFormat(fmt);
        this.format = new SimpleDateFormat(javaFormat);
    }

    public String format(Object value) {
        if (!(value instanceof Date)) {
            Log.error((Object)("Should be date" + value));
            return null;
        }
        Date date = (Date)value;
        String fDate = this.format.format(date);
        return fDate;
    }

    public Object parse(String value) {
        try {
            return this.format.parse(value);
        }
        catch (ParseException e) {
            Log.warn((Object)("Could not parse Date: " + value), (Throwable)e);
            return value;
        }
    }

    public void setFormat(String format) {
        String javaFormat = XlsDateFormatter.convertTojavaFormat(format);
        this.format = new SimpleDateFormat(javaFormat);
    }
}

