/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls.formatters;

import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.openl.rules.table.xls.formatters.AXlsFormatter;
import org.openl.rules.table.xls.formatters.XlsArrayFormatter;
import org.openl.rules.table.xls.formatters.XlsBooleanFormatter;
import org.openl.rules.table.xls.formatters.XlsDateFormatter;
import org.openl.rules.table.xls.formatters.XlsEnumFormatter;
import org.openl.rules.table.xls.formatters.XlsNumberFormatter;
import org.openl.rules.table.xls.formatters.XlsStringFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XlsFormattersManager {
    private static HashMap<Class<?>, AXlsFormatter> formatters = new HashMap();

    public static AXlsFormatter getFormatter(Class<?> clazz, String format) {
        AXlsFormatter formatter = formatters.get(clazz);
        if (formatter != null) {
            if (formatter instanceof XlsDateFormatter && StringUtils.isNotEmpty((String)format)) {
                ((XlsDateFormatter)formatter).setFormat(format);
            }
        } else if (clazz.isEnum()) {
            formatter = new XlsEnumFormatter(clazz);
        } else if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            AXlsFormatter componentFormatter = XlsFormattersManager.getFormatter(componentType, null);
            formatter = new XlsArrayFormatter(componentFormatter);
        }
        if (formatter == null) {
            formatter = new XlsStringFormatter();
        }
        return formatter;
    }

    public static AXlsFormatter getFormatter(Class<?> clazz) {
        return XlsFormattersManager.getFormatter(clazz, null);
    }

    static {
        formatters.put(Short.class, XlsNumberFormatter.General);
        formatters.put(Integer.class, XlsNumberFormatter.General);
        formatters.put(Float.class, XlsNumberFormatter.General);
        formatters.put(Double.class, XlsNumberFormatter.General);
        formatters.put(Boolean.class, new XlsBooleanFormatter());
        formatters.put(Date.class, new XlsDateFormatter(XlsDateFormatter.DEFAULT_XLS_DATE_FORMAT));
        formatters.put(String.class, new XlsStringFormatter());
    }
}

