/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls.formatters;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;
import org.openl.rules.table.xls.formatters.AXlsFormatter;
import org.openl.rules.table.xls.formatters.SegmentFormatter;
import org.openl.util.Log;
import org.openl.util.StringTool;
import org.openl.util.formatters.ConstTextFormatter;
import org.openl.util.formatters.IFormatter;
import org.openl.util.formatters.NumberTextFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XlsNumberFormatter
extends AXlsFormatter {
    public static final DecimalFormat DEFAULT_FORMAT = new DecimalFormat("0.00");
    public static final String GENERAL_FORMAT_STR = "#.######";
    public static final DecimalFormat GENERAL_FORMAT = new DecimalFormat("#.######");
    public static final XlsNumberFormatter General = new XlsNumberFormatter(new SegmentFormatter((IFormatter)new NumberTextFormatter(GENERAL_FORMAT), null), null, null);
    private static final String[] colorsStr = new String[]{"[Black]", "[Blue]", "[Cyan]", "[Green]", "[Magenta]", "[Red]", "[White]", "[Yellow]"};
    private static final short[][] colors = new short[][]{{0, 0, 0}, {0, 0, 255}, {0, 255, 255}, {0, 255, 0}, {255, 0, 255}, {255, 0, 0}, {255, 255, 255}, {255, 255, 0}};
    private SegmentFormatter positiveFormat;
    private SegmentFormatter negativeFormat;
    private SegmentFormatter zeroFormat;

    private static String detectColor(SegmentFormatter segmentFormatter, String format) {
        for (int i = 0; i < colorsStr.length; ++i) {
            if (!format.contains(colorsStr[i]) && !format.contains(colorsStr[i].toUpperCase())) continue;
            segmentFormatter.setColor(colors[i]);
            return format.substring(colorsStr[i].length());
        }
        return format;
    }

    private static SegmentFormatter getFormat(String format, Map<String, SegmentFormatter> existingFmts, boolean isNegative) {
        SegmentFormatter segmentFormatter = existingFmts.get(format);
        if (segmentFormatter != null) {
            return segmentFormatter;
        }
        segmentFormatter = XlsNumberFormatter.makeSegmentFormatter(format, isNegative);
        existingFmts.put(format, segmentFormatter);
        return segmentFormatter;
    }

    public static void main(String[] args) {
        double[] x = new double[]{-12.35, 12345.6789, 8.9, 0.631, 12.0, 12.35};
        String[] formats = new String[]{"$#,##0_);[Red]($#,##0)", "_(* #,##0.0_);_(* (#,##0.0);_(* \"-\"??_);_(@_)", "#,###", "#,", "####.#", "#.000", "0.#", "#.0#", "???.???", "#.0;(#.0)"};
        HashMap<String, SegmentFormatter> existingFmts = new HashMap<String, SegmentFormatter>();
        for (int i = 0; i < formats.length; ++i) {
            XlsNumberFormatter xnf = XlsNumberFormatter.makeFormat(formats[i], existingFmts);
            System.out.println(formats[i] + "  :  ");
            for (int j = 0; j < x.length; ++j) {
                Double value = new Double(x[j]);
                System.out.println(xnf.format(value) + "|  " + x[j]);
            }
            System.out.println();
        }
    }

    public static XlsNumberFormatter makeFormat(String xlsformat, Map<String, SegmentFormatter> existingFmts) {
        String[] fmts = StringTool.tokenize((String)xlsformat, (String)";");
        int N = 3;
        int NEG = 1;
        SegmentFormatter[] sff = new SegmentFormatter[N];
        int len = Math.min(fmts.length, N);
        for (int i = 0; i < len; ++i) {
            SegmentFormatter sf;
            sff[i] = sf = XlsNumberFormatter.getFormat(fmts[i], existingFmts, i == NEG);
        }
        return new XlsNumberFormatter(sff[0], sff[1], sff[2]);
    }

    private static SegmentFormatter makeSegmentFormatter(String format, boolean isNegative) {
        SegmentFormatter segmentFormatter = new SegmentFormatter();
        format = XlsNumberFormatter.detectColor(segmentFormatter, format);
        String javaFormat = XlsNumberFormatter.transformToJavaFormat(format, segmentFormatter);
        if (isNegative) {
            javaFormat = StringTool.removeChars((String)javaFormat, (String)"()") + ';' + javaFormat;
        }
        if (javaFormat.indexOf(35) < 0 && javaFormat.indexOf(48) < 0) {
            ConstTextFormatter textFormatter = new ConstTextFormatter();
            segmentFormatter.setFormatter((IFormatter)textFormatter);
            return segmentFormatter;
        }
        DecimalFormat decimalFormat = null;
        try {
            decimalFormat = new DecimalFormat(javaFormat);
        }
        catch (Throwable t) {
            Log.warn((Object)("Bad java format. Using default. Consider custom mapping: '" + javaFormat + "'"));
            decimalFormat = DEFAULT_FORMAT;
        }
        NumberTextFormatter textFormatter = new NumberTextFormatter(decimalFormat);
        segmentFormatter.setFormatter((IFormatter)textFormatter);
        return segmentFormatter;
    }

    public static String transformToJavaFormat(String xlsFormat, SegmentFormatter segmentFormatter) {
        StringBuffer sb = new StringBuffer();
        boolean skip = false;
        block5: for (int i = 0; i < xlsFormat.length(); ++i) {
            if (skip) {
                skip = false;
                continue;
            }
            char c = xlsFormat.charAt(i);
            switch (c) {
                case '_': {
                    sb.append(' ');
                    skip = true;
                    continue block5;
                }
                case '*': {
                    skip = true;
                    continue block5;
                }
                case '\"': 
                case '\\': {
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        xlsFormat = sb.toString();
        while (xlsFormat.endsWith(",")) {
            double newMultiplier = segmentFormatter.getMultiplier() / 1000.0;
            segmentFormatter.setMultiplier(newMultiplier);
            xlsFormat = xlsFormat.substring(0, xlsFormat.length() - 1);
        }
        xlsFormat = xlsFormat.indexOf(".?") >= 0 ? xlsFormat.replace('?', '#') : xlsFormat.replace('?', ' ');
        return xlsFormat;
    }

    public XlsNumberFormatter(SegmentFormatter positiveFormat, SegmentFormatter negativeFormat, SegmentFormatter zeroFormat) {
        this.positiveFormat = positiveFormat;
        this.negativeFormat = negativeFormat;
        this.zeroFormat = zeroFormat;
    }

    public String format(Object value, SegmentFormatter segmentFormatter) {
        if (!(value instanceof Number)) {
            Log.error((Object)("Should be Number " + value));
            return null;
        }
        Number number = (Number)value;
        if (segmentFormatter == null) {
            segmentFormatter = this.getSegmentFormatter(number);
        }
        if (segmentFormatter.getMultiplier() != 1.0) {
            value = new Double(number.doubleValue() * segmentFormatter.getMultiplier());
        }
        return segmentFormatter.getFormatter().format(value);
    }

    public String format(Object value) {
        return this.format(value, null);
    }

    public SegmentFormatter getSegmentFormatter(Number number) {
        SegmentFormatter segmentFormatter = this.positiveFormat;
        if (number.doubleValue() < 0.0) {
            segmentFormatter = this.isNegativeFormat();
        } else if (number.doubleValue() == 0.0) {
            segmentFormatter = this.zeroFormat();
        }
        return segmentFormatter;
    }

    private SegmentFormatter isNegativeFormat() {
        return this.negativeFormat == null ? this.positiveFormat : this.negativeFormat;
    }

    public Object parse(String value) {
        try {
            return NumberUtils.createNumber((String)value);
        }
        catch (NumberFormatException ex) {
            Object firstTry = this.positiveFormat.parse(value);
            if (firstTry != value) {
                return firstTry;
            }
            if (this.negativeFormat != null) {
                firstTry = this.negativeFormat.parse(value);
                if (firstTry != value) {
                    return firstTry;
                }
            } else {
                return value;
            }
            if (this.zeroFormat != null) {
                firstTry = this.zeroFormat.parse(value);
                if (firstTry != value) {
                    return firstTry;
                }
            } else {
                return value;
            }
            return value;
        }
    }

    private SegmentFormatter zeroFormat() {
        return this.zeroFormat == null ? this.positiveFormat : this.zeroFormat;
    }
}

