/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openl.binding.IBindingContext;
import org.openl.domain.EnumDomain;
import org.openl.domain.IDomain;
import org.openl.meta.StringValue;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.table.ui.ICellStyle;
import org.openl.rules.tbasic.Algorithm;
import org.openl.rules.tbasic.AlgorithmRow;
import org.openl.rules.tbasic.AlgorithmTableParserManager;
import org.openl.rules.tbasic.AlgorithmTreeNode;
import org.openl.rules.tbasic.RowParser;
import org.openl.rules.tbasic.compile.AlgorithmCompiler;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenClass;
import org.openl.types.impl.DomainOpenClass;
import org.openl.types.java.JavaOpenClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlgorithmBuilder {
    private static final String OPERATION = "Operation";
    public static String[] algorithmOperations = new String[]{"SET", "VAR", "IF", "ELSE", "WHILE", "SUB", "FUNCTION", "END IF", "END WHILE", "END FOR EACH", "END SUB", "END FUNCTION", "GOTO", "BREAK", "CONTINUE", "RETURN"};
    private final IBindingContext bindingContext;
    private final Algorithm algorithm;
    private final TableSyntaxNode tsn;
    private Map<String, AlgorithmColumn> columns;

    public AlgorithmBuilder(IBindingContext ctx, Algorithm algorithm, TableSyntaxNode tsn) {
        this.bindingContext = ctx;
        this.algorithm = algorithm;
        this.tsn = tsn;
    }

    private void bindMetaInfo(IGridTable grid, int c, int r) {
        CellMetaInfo meta = new CellMetaInfo(CellMetaInfo.Type.DT_CA_CODE, null, (IOpenClass)new DomainOpenClass("operation", (IOpenClass)JavaOpenClass.STRING, (IDomain)new EnumDomain((Object[])algorithmOperations), null), false);
        IWritableGrid wgrid = IWritableGrid.Tool.getWritableGrid(grid);
        wgrid.setCellMetaInfo(IGridRegion.Tool.getAbsoluteColumn(grid.getRegion(), c), IGridRegion.Tool.getAbsoluteRow(grid.getRegion(), r), meta);
    }

    public void build(ILogicalTable tableBody) throws Exception {
        if (tableBody == null) {
            throw SyntaxNodeExceptionUtils.createError((String)"Invalid table. Provide table body", null, (ISyntaxNode)this.tsn);
        }
        if (tableBody.getHeight() <= 2) {
            throw SyntaxNodeExceptionUtils.createError((String)"Unsufficient rows. Must be more than 2!", null, (ISyntaxNode)this.tsn);
        }
        this.prepareColumns(tableBody);
        List<AlgorithmRow> algorithmRows = this.buildRows(tableBody);
        RowParser rowParser = new RowParser(algorithmRows, AlgorithmTableParserManager.instance().getAlgorithmSpecification());
        List<AlgorithmTreeNode> parsedNodes = rowParser.parse();
        AlgorithmCompiler compiler = new AlgorithmCompiler(this.bindingContext, this.algorithm.getHeader(), parsedNodes);
        compiler.compile(this.algorithm);
    }

    private List<AlgorithmRow> buildRows(ILogicalTable tableBody) throws SyntaxNodeException {
        ArrayList<AlgorithmRow> result = new ArrayList<AlgorithmRow>();
        IGridTable grid = ((ILogicalTable)tableBody.getRows(2)).getSource();
        for (int r = 0; r < grid.getHeight(); ++r) {
            AlgorithmRow aRow = new AlgorithmRow();
            aRow.setRowNumber(r + 1);
            IGridTable rowTable = (IGridTable)grid.getRow(r);
            aRow.setGridRegion(rowTable.getRegion());
            for (AlgorithmColumn column : this.columns.values()) {
                int c = column.columnIndex;
                IGridTable valueTable = (IGridTable)rowTable.getColumn(c);
                aRow.setValueGridRegion(column.id, valueTable.getRegion());
                String value = grid.getCell(c, r).getStringValue();
                if (value == null) {
                    value = "";
                }
                StringValue sv = new StringValue(value, "cell" + r + "_" + c, null, (IOpenSourceCodeModule)new GridCellSourceCodeModule(grid, c, r, this.bindingContext));
                this.setRowField(aRow, column.id, sv);
                if (!OPERATION.equalsIgnoreCase(column.id)) continue;
                ICellStyle cellStyle = grid.getCell(c, r).getStyle();
                int i = cellStyle == null ? 0 : cellStyle.getIdent();
                aRow.setOperationLevel(i);
                this.bindMetaInfo(grid, c, r);
            }
            result.add(aRow);
        }
        return result;
    }

    private void prepareColumns(ILogicalTable tableBody) throws SyntaxNodeException {
        this.columns = new HashMap<String, AlgorithmColumn>();
        ILogicalTable ids = (ILogicalTable)tableBody.getRow(0);
        for (int c = 0; c < ids.getWidth(); ++c) {
            String id = this.safeId(((ILogicalTable)ids.getColumn(c)).getSource().getCell(0, 0).getStringValue());
            if (id.length() == 0) continue;
            if (this.columns.get(id) != null) {
                throw SyntaxNodeExceptionUtils.createError((String)("Duplicate column '" + id + "'!"), null, (ISyntaxNode)this.tsn);
            }
            this.columns.put(id, new AlgorithmColumn(id, c));
        }
    }

    private String safeId(String s) {
        String id = "";
        if (s != null) {
            id = s.trim().toLowerCase();
        }
        return id;
    }

    private void setRowField(AlgorithmRow row, String column, StringValue sv) throws SyntaxNodeException {
        if ("label".equalsIgnoreCase(column)) {
            row.setLabel(sv);
        } else if ("description".equalsIgnoreCase(column)) {
            row.setDescription(sv);
        } else if ("operation".equalsIgnoreCase(column)) {
            row.setOperation(sv);
        } else if ("condition".equalsIgnoreCase(column)) {
            row.setCondition(sv);
        } else if ("action".equalsIgnoreCase(column)) {
            row.setAction(sv);
        } else if ("before".equalsIgnoreCase(column)) {
            row.setBefore(sv);
        } else if ("after".equalsIgnoreCase(column)) {
            row.setAfter(sv);
        } else {
            throw SyntaxNodeExceptionUtils.createError((String)("Invalid column id '" + column + "'!"), null, (ISyntaxNode)this.tsn);
        }
    }

    private static class AlgorithmColumn {
        private String id;
        private int columnIndex;

        private AlgorithmColumn(String id, int columnIndex) {
            this.id = id;
            this.columnIndex = columnIndex;
        }
    }
}

