/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.exception.OpenLRuntimeException;
import org.openl.rules.table.DefaultInvokerWithTrace;
import org.openl.rules.tbasic.Algorithm;
import org.openl.rules.tbasic.runtime.TBasicContextHolderEnv;
import org.openl.rules.tbasic.runtime.TBasicVM;
import org.openl.rules.tbasic.runtime.debug.TBasicAlgorithmTraceObject;
import org.openl.types.IDynamicObject;
import org.openl.types.impl.DelegatedDynamicObject;
import org.openl.vm.IRuntimeEnv;
import org.openl.vm.trace.ITracerObject;
import org.openl.vm.trace.Tracer;

public class AlgorithmInvoker
extends DefaultInvokerWithTrace {
    private final Log LOG = LogFactory.getLog(AlgorithmInvoker.class);
    private Algorithm algorithm;

    public AlgorithmInvoker(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public boolean canInvoke() {
        return this.algorithm.getAlgorithmSteps() != null;
    }

    public TBasicAlgorithmTraceObject createTraceObject(Object[] params) {
        return new TBasicAlgorithmTraceObject(this.algorithm, params);
    }

    public OpenLRuntimeException getError() {
        return new OpenLRuntimeException((Throwable)this.algorithm.getSyntaxNode().getErrors()[0]);
    }

    public Object invokeSimple(Object target, Object[] params, IRuntimeEnv env) {
        DelegatedDynamicObject thisInstance = new DelegatedDynamicObject(this.algorithm.getThisClass(), (IDynamicObject)target);
        TBasicVM algorithmVM = new TBasicVM(this.algorithm.getAlgorithmSteps(), this.algorithm.getLabels());
        TBasicContextHolderEnv runtimeEnvironment = new TBasicContextHolderEnv(env, thisInstance, params, algorithmVM);
        return algorithmVM.run(runtimeEnvironment, false);
    }

    public Object invokeTraced(Object target, Object[] params, IRuntimeEnv env) {
        DelegatedDynamicObject thisInstance = new DelegatedDynamicObject(this.algorithm.getThisClass(), (IDynamicObject)target);
        TBasicVM algorithmVM = new TBasicVM(this.algorithm.getAlgorithmSteps(), this.algorithm.getLabels());
        TBasicContextHolderEnv runtimeEnvironment = new TBasicContextHolderEnv(env, thisInstance, params, algorithmVM);
        TBasicAlgorithmTraceObject algorithmTracer = this.createTraceObject(params);
        Tracer.getTracer().push((ITracerObject)algorithmTracer);
        Object resultValue = null;
        try {
            resultValue = algorithmVM.run(runtimeEnvironment, true);
            algorithmTracer.setResult(resultValue);
        }
        catch (RuntimeException e) {
            algorithmTracer.setError(e);
            this.LOG.error((Object)"Error when tracing TBasic table", (Throwable)e);
            throw e;
        }
        finally {
            Tracer.getTracer().pop();
        }
        return resultValue;
    }
}

