/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic;

import java.net.URL;
import java.util.List;
import org.openl.rules.tbasic.IAlgorithmTableParserManager;
import org.openl.rules.tbasic.TableParserSpecificationBean;
import org.openl.rules.tbasic.compile.ConversionRuleBean;
import org.openl.runtime.EngineFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AlgorithmTableParserManager
implements IAlgorithmTableParserManager {
    private static volatile AlgorithmTableParserManager instance;
    private static Object synchObjectForInstance;
    private final IAlgorithmTableParserManager rulesWrapperInstance;
    private volatile ConversionRuleBean[] convertionRules;
    private volatile ConversionRuleBean[] fixedConvertionRules;
    private Object synchObjectForConvertionRules = new Object();
    private Object synchObjectForFixedConvertionRules = new Object();

    public static AlgorithmTableParserManager instance() {
        AlgorithmTableParserManager.lazyLoadInstance();
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void lazyLoadInstance() {
        if (instance == null) {
            Object object = synchObjectForInstance;
            synchronized (object) {
                if (instance == null) {
                    instance = new AlgorithmTableParserManager();
                }
            }
        }
    }

    private AlgorithmTableParserManager() {
        String sourceType = "org.openl.xls";
        URL sourceFile = AlgorithmTableParserManager.class.getResource("AlgorithmTableSpecification.xls");
        EngineFactory engineFactory = new EngineFactory(sourceType, sourceFile, IAlgorithmTableParserManager.class);
        engineFactory.setExecutionMode(true);
        this.rulesWrapperInstance = (IAlgorithmTableParserManager)engineFactory.makeInstance();
    }

    private ConversionRuleBean[] fixBrokenValues(ConversionRuleBean[] conversionRules) {
        for (ConversionRuleBean conversionRule : conversionRules) {
            this.fixBrokenValues(conversionRule.getOperationType());
            this.fixBrokenValues(conversionRule.getOperationParam1());
            this.fixBrokenValues(conversionRule.getOperationParam2());
            this.fixBrokenValues(conversionRule.getLabel());
            this.fixBrokenValues(conversionRule.getNameForDebug());
        }
        return conversionRules;
    }

    private void fixBrokenValues(String[] label) {
        for (int i = 0; i < label.length; ++i) {
            if (label[i].equalsIgnoreCase("N/A")) {
                label[i] = null;
                continue;
            }
            if (!label[i].equalsIgnoreCase("\"\"")) continue;
            label[i] = "";
        }
    }

    @Override
    public TableParserSpecificationBean[] getAlgorithmSpecification() {
        TableParserSpecificationBean[] result = this.rulesWrapperInstance.getAlgorithmSpecification();
        return result;
    }

    @Override
    public ConversionRuleBean[] getConversionRules() {
        this.lazyLoadConversionRules();
        return this.convertionRules;
    }

    public ConversionRuleBean[] getFixedConversionRules() {
        this.lazyLoadFixedConvertionRules();
        return this.fixedConvertionRules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyLoadConversionRules() {
        if (this.convertionRules == null) {
            Object object = this.synchObjectForConvertionRules;
            synchronized (object) {
                if (this.convertionRules == null) {
                    this.convertionRules = this.rulesWrapperInstance.getConversionRules();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyLoadFixedConvertionRules() {
        if (this.fixedConvertionRules == null) {
            Object object = this.synchObjectForFixedConvertionRules;
            synchronized (object) {
                if (this.fixedConvertionRules == null) {
                    ConversionRuleBean[] draftConvertionRules = (ConversionRuleBean[])this.getConversionRules().clone();
                    this.fixedConvertionRules = this.fixBrokenValues(draftConvertionRules);
                }
            }
        }
    }

    @Override
    public String whatIsOperationsGroupName(List<String> groupedOperationNames) {
        return this.rulesWrapperInstance.whatIsOperationsGroupName(groupedOperationNames);
    }

    @Override
    public String[] whatOperationsToGroup(String keyword) {
        return this.rulesWrapperInstance.whatOperationsToGroup(keyword);
    }

    static {
        synchObjectForInstance = new Object();
    }
}

