/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic.compile;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.module.ModuleBindingContext;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.engine.OpenLManager;
import org.openl.meta.StringValue;
import org.openl.rules.tbasic.Algorithm;
import org.openl.rules.tbasic.AlgorithmSubroutineMethod;
import org.openl.rules.tbasic.AlgorithmTreeNode;
import org.openl.rules.tbasic.NoParamMethodField;
import org.openl.rules.tbasic.compile.AlgorithmCompilerTool;
import org.openl.rules.tbasic.compile.AlgorithmFunctionCompiler;
import org.openl.rules.tbasic.compile.CompileContext;
import org.openl.rules.tbasic.compile.ConversionRuleBean;
import org.openl.rules.tbasic.compile.ConversionRuleStep;
import org.openl.rules.tbasic.compile.ConversionRulesController;
import org.openl.rules.tbasic.compile.LabelManager;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IMethodCaller;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.DynamicObjectField;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.types.java.JavaOpenClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlgorithmCompiler {
    private IBindingContext context;
    private IOpenMethodHeader header;
    private List<AlgorithmTreeNode> nodesToCompile;
    private CompileContext mainCompileContext;
    private List<AlgorithmFunctionCompiler> functions = new ArrayList<AlgorithmFunctionCompiler>();
    private LabelManager labelManager;
    private ModuleOpenClass thisTargetClass;
    private IBindingContext thisContext;

    public AlgorithmCompiler(IBindingContext context, IOpenMethodHeader header, List<AlgorithmTreeNode> nodesToCompile) {
        this.context = context;
        this.header = header;
        this.nodesToCompile = nodesToCompile;
    }

    public void compile(Algorithm algorithm) throws Exception {
        this.initialization(algorithm);
        this.precompile(this.nodesToCompile);
        this.compile(this.nodesToCompile);
        this.postprocess(algorithm);
    }

    private void compile(List<AlgorithmTreeNode> nodesToProcess) throws Exception {
        for (AlgorithmFunctionCompiler functionCompiler : this.functions) {
            functionCompiler.compile();
        }
    }

    private void createAlgorithmInternalMethod(List<AlgorithmTreeNode> nodesToCompile, IOpenClass returnType, CompileContext methodContext) throws SyntaxNodeException {
        for (StringValue label : nodesToCompile.get(0).getLabels()) {
            String methodName = label.getValue();
            OpenMethodHeader methodHeader = new OpenMethodHeader(methodName, returnType, IMethodSignature.VOID, (IOpenClass)this.thisTargetClass);
            AlgorithmSubroutineMethod method = new AlgorithmSubroutineMethod((IOpenMethodHeader)methodHeader);
            this.thisTargetClass.addMethod((IOpenMethod)method);
            NoParamMethodField methodAlternative = new NoParamMethodField(methodName, method);
            this.thisTargetClass.addField((IOpenField)methodAlternative);
            this.functions.add(new AlgorithmFunctionCompiler(nodesToCompile, methodContext, method, this));
        }
        Map<String, AlgorithmTreeNode> internalLablesOfMethod = AlgorithmCompilerTool.getAllDeclaredLables(nodesToCompile);
        methodContext.registerGroupOfLabels(internalLablesOfMethod);
    }

    private IBindingContext createBindingContext() {
        if (this.thisContext == null) {
            this.thisContext = new ModuleBindingContext(this.context, this.thisTargetClass);
        }
        return this.thisContext;
    }

    private void declareFunction(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep convertionStep) throws SyntaxNodeException {
        String returnValueInstruction = convertionStep.getOperationParam1();
        JavaOpenClass returnType = JavaOpenClass.VOID;
        returnType = AlgorithmCompilerTool.isOperationFieldInstruction(returnValueInstruction) ? this.getTypeOfField(AlgorithmCompilerTool.getCellContent(nodesToCompile, returnValueInstruction)) : this.discoverFunctionType(nodesToCompile.get(0).getChildren(), returnValueInstruction);
        this.createAlgorithmInternalMethod(nodesToCompile, (IOpenClass)returnType, new CompileContext());
    }

    private void declareSubroutine(List<AlgorithmTreeNode> nodesToCompile) throws SyntaxNodeException {
        CompileContext subroutineContext = new CompileContext();
        subroutineContext.registerGroupOfLabels(this.mainCompileContext.getExistingLables());
        this.createAlgorithmInternalMethod(nodesToCompile, (IOpenClass)JavaOpenClass.VOID, subroutineContext);
    }

    private void declareVariable(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep conversionStep) throws SyntaxNodeException {
        String variableNameParameter = conversionStep.getOperationParam1();
        String variableAssignmentParameter = conversionStep.getOperationParam2();
        StringValue variableName = AlgorithmCompilerTool.getCellContent(nodesToCompile, variableNameParameter);
        IOpenClass variableType = this.getTypeOfField(AlgorithmCompilerTool.getCellContent(nodesToCompile, variableAssignmentParameter));
        this.initNewInternalVariable(variableName.getValue(), variableType);
    }

    private IOpenClass discoverFunctionType(List<AlgorithmTreeNode> children, String returnValueInstruction) throws SyntaxNodeException {
        List<AlgorithmTreeNode> returnNodes = this.findFirstReturn(children);
        if (returnNodes == null || returnNodes.size() == 0) {
            StringValue lastAction = AlgorithmCompilerTool.getLastExecutableOperation(children).getAlgorithmRow().getAction();
            return this.getTypeOfField(lastAction);
        }
        String fieldWithOpenLStatement = "RETURN.condition";
        return this.getTypeOfField(AlgorithmCompilerTool.getCellContent(returnNodes, fieldWithOpenLStatement));
    }

    private List<AlgorithmTreeNode> findFirstReturn(List<AlgorithmTreeNode> nodes) {
        List<AlgorithmTreeNode> returnNodeSubList = null;
        for (int i = 0; i < nodes.size() && returnNodeSubList == null; ++i) {
            if (nodes.get(i).getSpecification().getKeyword().equals("RETURN")) {
                returnNodeSubList = nodes.subList(i, i + 1);
                continue;
            }
            if (nodes.get(i).getChildren() == null) continue;
            returnNodeSubList = this.findFirstReturn(nodes.get(i).getChildren());
        }
        return returnNodeSubList;
    }

    private String generateOpenClassName() {
        return this.header.getName();
    }

    public LabelManager getLabelManager() {
        return this.labelManager;
    }

    private List<AlgorithmTreeNode> getMainFunctionBody() {
        int currentOperationIndex;
        for (currentOperationIndex = 0; currentOperationIndex < this.nodesToCompile.size() && !this.nodesToCompile.get(currentOperationIndex).getSpecification().getKeyword().equals("FUNCTION") && !this.nodesToCompile.get(currentOperationIndex).getSpecification().getKeyword().equals("SUB"); ++currentOperationIndex) {
        }
        return this.nodesToCompile.subList(0, currentOperationIndex);
    }

    public IOpenClass getThisTargetClass() {
        return this.thisTargetClass;
    }

    public IOpenClass getTypeOfField(StringValue fieldContent) {
        IOpenSourceCodeModule src = fieldContent.asSourceCodeModule();
        OpenL openl = this.context.getOpenL();
        IMethodSignature signature = this.header.getSignature();
        IBindingContext cxt = this.createBindingContext();
        IOpenClass filedType = OpenLManager.makeMethodWithUnknownType((OpenL)openl, (IOpenSourceCodeModule)src, (String)("cell_" + fieldContent.getValue()), (IMethodSignature)signature, (IOpenClass)this.thisTargetClass, (IBindingContext)cxt).getMethod().getType();
        return filedType;
    }

    private void initialization(Algorithm algorithm) throws SyntaxNodeException {
        this.labelManager = new LabelManager();
        this.thisTargetClass = new ModuleOpenClass(null, this.generateOpenClassName(), this.context.getOpenL());
        this.initNewInternalVariable("ERROR", this.getTypeOfField(new StringValue("new RuntimeException()")));
        this.initNewInternalVariable("Error Message", this.getTypeOfField(new StringValue("\"Error!\"")));
        this.mainCompileContext = new CompileContext();
        List<AlgorithmTreeNode> mainFunction = this.getMainFunctionBody();
        this.mainCompileContext.registerGroupOfLabels(AlgorithmCompilerTool.getAllDeclaredLables(mainFunction));
        this.functions.add(new AlgorithmFunctionCompiler(mainFunction, this.mainCompileContext, algorithm, this));
    }

    private void initNewInternalVariable(String variableName, IOpenClass variableType) {
        DynamicObjectField field = new DynamicObjectField((IOpenClass)this.thisTargetClass, variableName, variableType);
        this.thisTargetClass.addField((IOpenField)field);
    }

    public IMethodCaller makeMethod(IOpenSourceCodeModule src, String methodName) {
        OpenL openl = this.context.getOpenL();
        IMethodSignature signature = this.header.getSignature();
        IBindingContext cxt = this.createBindingContext();
        return OpenLManager.makeMethodWithUnknownType((OpenL)openl, (IOpenSourceCodeModule)src, (String)methodName, (IMethodSignature)signature, (IOpenClass)this.thisTargetClass, (IBindingContext)cxt);
    }

    private void postprocess(Algorithm algorithm) {
        for (AlgorithmFunctionCompiler functionCompiler : this.functions) {
            functionCompiler.postprocess();
        }
        algorithm.setThisClass(this.getThisTargetClass());
    }

    private void precompile(List<AlgorithmTreeNode> nodesToProcess) throws SyntaxNodeException {
        this.precompileNestedNodes(nodesToProcess);
    }

    private void precompileLinkedNodesGroup(List<AlgorithmTreeNode> nodesToCompile) throws SyntaxNodeException {
        assert (nodesToCompile.size() > 0);
        ConversionRuleBean conversionRule = ConversionRulesController.getInstance().getConvertionRule(nodesToCompile);
        for (ConversionRuleStep convertionStep : conversionRule.getConvertionSteps()) {
            this.preprocessConversionStep(nodesToCompile, convertionStep);
        }
    }

    private void precompileNestedNodes(List<AlgorithmTreeNode> nodesToProcess) throws SyntaxNodeException {
        int linkedNodesGroupSize;
        for (int i = 0; i < nodesToProcess.size(); i += linkedNodesGroupSize) {
            linkedNodesGroupSize = AlgorithmCompilerTool.getLinkedNodesGroupSize(nodesToProcess, i);
            List<AlgorithmTreeNode> nodesToCompile = nodesToProcess.subList(i, i + linkedNodesGroupSize);
            this.precompileLinkedNodesGroup(nodesToCompile);
        }
    }

    private void preprocessConversionStep(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep conversionStep) throws SyntaxNodeException {
        assert (nodesToCompile.size() > 0);
        assert (conversionStep != null);
        String operationType = conversionStep.getOperationType();
        if (operationType.startsWith("!") && !operationType.equals("!CheckLabel")) {
            if (operationType.equals("!Compile")) {
                List<AlgorithmTreeNode> nodesToProcess = AlgorithmCompilerTool.getNestedInstructionsBlock(nodesToCompile, conversionStep.getOperationParam1());
                this.precompileNestedNodes(nodesToProcess);
            } else if (operationType.equals("!Declare")) {
                this.declareVariable(nodesToCompile, conversionStep);
            } else if (operationType.equals("!Subroutine")) {
                this.declareSubroutine(nodesToCompile);
            } else if (operationType.equals("!Function")) {
                this.declareFunction(nodesToCompile, conversionStep);
            } else {
                IOpenSourceCodeModule errorSource = nodesToCompile.get(0).getAlgorithmRow().getOperation().asSourceCodeModule();
                throw SyntaxNodeExceptionUtils.createError((String)String.format("Unknown compilation instruction %s", operationType), (IOpenSourceCodeModule)errorSource);
            }
        }
    }
}

