/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic.compile;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.openl.meta.StringValue;
import org.openl.rules.tbasic.AlgorithmTreeNode;
import org.openl.rules.tbasic.compile.AlgorithmCompiler;
import org.openl.rules.tbasic.compile.AlgorithmCompilerTool;
import org.openl.rules.tbasic.compile.AlgorithmOperationSource;
import org.openl.rules.tbasic.compile.CompileContext;
import org.openl.rules.tbasic.compile.ConversionRuleBean;
import org.openl.rules.tbasic.compile.ConversionRuleStep;
import org.openl.rules.tbasic.compile.ConversionRulesController;
import org.openl.rules.tbasic.compile.LabelManager;
import org.openl.rules.tbasic.runtime.operations.RuntimeOperation;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IMethodCaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlgoritmNodesCompiler {
    private LabelManager labelManager;
    private CompileContext currentCompileContext;
    private AlgorithmCompiler compiler;

    public AlgoritmNodesCompiler(LabelManager labelManager, CompileContext currentCompileContext, AlgorithmCompiler compiler) {
        this.labelManager = labelManager;
        this.currentCompileContext = currentCompileContext;
        this.compiler = compiler;
    }

    private RuntimeOperation compileAfter(List<AlgorithmTreeNode> nodesToCompile) throws Exception {
        String afterFieldName = "after";
        return this.createOperationForFirstNodeField(nodesToCompile, "after");
    }

    private RuntimeOperation compileBefore(List<AlgorithmTreeNode> nodesToCompile) throws Exception {
        String beforeFieldName = "before";
        return this.createOperationForFirstNodeField(nodesToCompile, "before");
    }

    private List<RuntimeOperation> compileLinkedNodesGroup(List<AlgorithmTreeNode> nodesToCompile) throws Exception {
        List<StringValue> userDefinedLabels;
        assert (nodesToCompile.size() > 0);
        ArrayList<RuntimeOperation> emittedOperations = new ArrayList<RuntimeOperation>();
        ConversionRuleBean conversionRule = ConversionRulesController.getInstance().getConvertionRule(nodesToCompile);
        boolean isLoopOperation = nodesToCompile.get(0).getSpecification().isLoopOperation();
        this.labelManager.startOperationsSet(isLoopOperation);
        this.labelManager.generateAllLabels(conversionRule.getLabel());
        RuntimeOperation beforeOperation = this.compileBefore(nodesToCompile);
        if (beforeOperation != null) {
            emittedOperations.add(beforeOperation);
        }
        for (ConversionRuleStep convertionStep : conversionRule.getConvertionSteps()) {
            List<RuntimeOperation> stepEmittedOperations = this.processConversionStep(nodesToCompile, convertionStep);
            emittedOperations.addAll(stepEmittedOperations);
        }
        RuntimeOperation afterOperation = this.compileAfter(nodesToCompile);
        if (afterOperation != null) {
            emittedOperations.add(afterOperation);
        }
        if (!(userDefinedLabels = nodesToCompile.get(0).getLabels()).isEmpty() && emittedOperations.size() > 0) {
            for (StringValue userDefinedLabel : userDefinedLabels) {
                this.currentCompileContext.setLabel(userDefinedLabel.getValue(), (RuntimeOperation)emittedOperations.get(0));
            }
        }
        this.labelManager.finishOperationsSet();
        return emittedOperations;
    }

    private List<RuntimeOperation> compileNestedNodes(List<AlgorithmTreeNode> nodesToProcess) throws Exception {
        int linkedNodesGroupSize;
        ArrayList<RuntimeOperation> emittedOperations = new ArrayList<RuntimeOperation>();
        for (int i = 0; i < nodesToProcess.size(); i += linkedNodesGroupSize) {
            if (this.hasUnreachableCode(nodesToProcess, i)) {
                IOpenSourceCodeModule errorSource = nodesToProcess.get(i + 1).getAlgorithmRow().getOperation().asSourceCodeModule();
                throw SyntaxNodeExceptionUtils.createError((String)"Unreachable code. Operations after BREAK,CONTINUE not allowed.", (IOpenSourceCodeModule)errorSource);
            }
            linkedNodesGroupSize = AlgorithmCompilerTool.getLinkedNodesGroupSize(nodesToProcess, i);
            List<AlgorithmTreeNode> nodesToCompile = nodesToProcess.subList(i, i + linkedNodesGroupSize);
            emittedOperations.addAll(this.compileLinkedNodesGroup(nodesToCompile));
        }
        return emittedOperations;
    }

    public List<RuntimeOperation> compileNodes(List<AlgorithmTreeNode> nodes) throws Exception {
        return this.compileNestedNodes(nodes);
    }

    private Object convertParam(List<AlgorithmTreeNode> nodesToCompile, Class<? extends Object> clazz, String operationParam) throws SyntaxNodeException {
        if (clazz.equals(String.class)) {
            if (this.labelManager.isLabelInstruction(operationParam)) {
                return this.labelManager.getLabelByInstruction(operationParam);
            }
            if (AlgorithmCompilerTool.isOperationFieldInstruction(operationParam)) {
                StringValue content = AlgorithmCompilerTool.getCellContent(nodesToCompile, operationParam);
                return content.getValue();
            }
            return operationParam;
        }
        if (clazz.equals(Boolean.TYPE)) {
            return Boolean.parseBoolean(operationParam);
        }
        if (clazz.equals(IMethodCaller.class)) {
            if (operationParam == null) {
                return null;
            }
            IOpenSourceCodeModule src = AlgorithmCompilerTool.getCellContent(nodesToCompile, operationParam).asSourceCodeModule();
            AlgorithmTreeNode executionNode = AlgorithmCompilerTool.extractOperationNode(nodesToCompile, operationParam);
            String methodName = operationParam.replace('.', '_') + "_row_" + executionNode.getAlgorithmRow().getRowNumber();
            return this.compiler.makeMethod(src, methodName);
        }
        IOpenSourceCodeModule errorSource = nodesToCompile.get(0).getAlgorithmRow().getOperation().asSourceCodeModule();
        throw SyntaxNodeExceptionUtils.createError((String)String.format("Compilation failure. Can't convert parameter %s to type %s", operationParam, clazz.toString()), (IOpenSourceCodeModule)errorSource);
    }

    private RuntimeOperation createOperation(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep conversionStep) throws Exception {
        Class<?> clazz = Class.forName("org.openl.rules.tbasic.runtime.operations." + conversionStep.getOperationType() + "Operation");
        Constructor<?> constructor = clazz.getConstructors()[0];
        Object[] params = new Object[constructor.getParameterTypes().length];
        if (constructor.getParameterTypes().length > 0) {
            params[0] = this.convertParam(nodesToCompile, constructor.getParameterTypes()[0], conversionStep.getOperationParam1());
        }
        if (constructor.getParameterTypes().length > 1) {
            params[1] = this.convertParam(nodesToCompile, constructor.getParameterTypes()[1], conversionStep.getOperationParam2());
        }
        RuntimeOperation emittedOperation = (RuntimeOperation)constructor.newInstance(params);
        AlgorithmOperationSource source = AlgorithmCompilerTool.getOperationSource(nodesToCompile, conversionStep.getOperationParam1());
        emittedOperation.setSourceCode(source);
        String nameForDebug = conversionStep.getNameForDebug();
        emittedOperation.setNameForDebug(nameForDebug);
        emittedOperation.setSignificantForDebug(nameForDebug != null);
        return emittedOperation;
    }

    private RuntimeOperation createOperationForFirstNodeField(List<AlgorithmTreeNode> nodesToCompile, String fieldName) throws Exception {
        String param = nodesToCompile.get(0).getAlgorithmRow().getOperation() + "." + fieldName;
        StringValue content = AlgorithmCompilerTool.getCellContent(nodesToCompile, param);
        RuntimeOperation operation = null;
        if (content.getValue() != null && content.getValue().trim() != "") {
            ConversionRuleStep conversionStep = new ConversionRuleStep("Perform", param, null, null, fieldName + " execution");
            operation = this.createOperation(nodesToCompile, conversionStep);
        }
        return operation;
    }

    private boolean hasUnreachableCode(List<AlgorithmTreeNode> nodesToProcess, int indexOfReturn) {
        return indexOfReturn < nodesToProcess.size() - 1 && (nodesToProcess.get(indexOfReturn).getSpecification().getKeyword().equals("BREAK") || nodesToProcess.get(indexOfReturn).getSpecification().getKeyword().equals("CONTINUE"));
    }

    private List<RuntimeOperation> processConversionStep(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep conversionStep) throws Exception {
        String labelName;
        String operationType;
        assert (nodesToCompile.size() > 0);
        assert (conversionStep != null);
        String label = null;
        ArrayList<RuntimeOperation> emittedOperations = new ArrayList<RuntimeOperation>();
        if (conversionStep.getLabelInstruction() != null) {
            label = this.labelManager.getLabelByInstruction(conversionStep.getLabelInstruction());
        }
        if (!(operationType = conversionStep.getOperationType()).startsWith("!")) {
            RuntimeOperation emittedOperation = this.createOperation(nodesToCompile, conversionStep);
            emittedOperations.add(emittedOperation);
        } else if (operationType.equals("!Compile")) {
            List<AlgorithmTreeNode> nodesToProcess = AlgorithmCompilerTool.getNestedInstructionsBlock(nodesToCompile, conversionStep.getOperationParam1());
            emittedOperations.addAll(this.compileNestedNodes(nodesToProcess));
        } else if (operationType.equals("!CheckLabel") && !this.currentCompileContext.isLabelRegistered(labelName = (String)this.convertParam(nodesToCompile, String.class, conversionStep.getOperationParam1()))) {
            IOpenSourceCodeModule errorSource = nodesToCompile.get(0).getAlgorithmRow().getOperation().asSourceCodeModule();
            throw SyntaxNodeExceptionUtils.createError((String)("Such label is not available from this place: \"" + labelName + "\"."), (IOpenSourceCodeModule)errorSource);
        }
        if (emittedOperations.size() > 0 && label != null) {
            this.currentCompileContext.registerNewLabel(label, nodesToCompile.get(0));
            this.currentCompileContext.setLabel(label, (RuntimeOperation)emittedOperations.get(0));
        }
        return emittedOperations;
    }
}

