/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic.compile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openl.rules.tbasic.AlgorithmTreeNode;
import org.openl.rules.tbasic.runtime.operations.RuntimeOperation;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompileContext {
    private List<RuntimeOperation> operations = new ArrayList<RuntimeOperation>();
    private Map<String, RuntimeOperation> localLabelsRegister = new HashMap<String, RuntimeOperation>();
    private Map<String, AlgorithmTreeNode> existingLables = new HashMap<String, AlgorithmTreeNode>();

    public Map<String, AlgorithmTreeNode> getExistingLables() {
        return this.existingLables;
    }

    public Map<String, RuntimeOperation> getLocalLabelsRegister() {
        return this.localLabelsRegister;
    }

    public List<RuntimeOperation> getOperations() {
        return this.operations;
    }

    public boolean isLabelRegistered(String labelName) {
        return this.existingLables.containsKey(labelName);
    }

    public void registerGroupOfLabels(Map<String, AlgorithmTreeNode> labelToAdd) throws SyntaxNodeException {
        for (Map.Entry<String, AlgorithmTreeNode> label : labelToAdd.entrySet()) {
            this.registerNewLabel(label.getKey(), label.getValue());
        }
    }

    public void registerNewLabel(String labelName, AlgorithmTreeNode sourceNode) throws SyntaxNodeException {
        if (this.isLabelRegistered(labelName)) {
            IOpenSourceCodeModule errorSource = sourceNode.getAlgorithmRow().getOperation().asSourceCodeModule();
            throw SyntaxNodeExceptionUtils.createError((String)("Such label has been already declared : \"" + labelName + "\"."), (IOpenSourceCodeModule)errorSource);
        }
        this.existingLables.put(labelName, sourceNode);
    }

    public void setLabel(String labelName, RuntimeOperation labeledOperation) throws SyntaxNodeException {
        if (!this.isLabelRegistered(labelName)) {
            IOpenSourceCodeModule errorSource = labeledOperation.getSourceCode().getSourceModule();
            throw SyntaxNodeExceptionUtils.createError((String)("Such lablel isn't declared : \"" + labelName + "\"."), (IOpenSourceCodeModule)errorSource);
        }
        this.localLabelsRegister.put(labelName, labeledOperation);
    }
}

