/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic.runtime;

import java.util.List;
import java.util.Map;
import org.openl.binding.impl.ControlSignal;
import org.openl.rules.tbasic.runtime.AlgorithmErrorHelper;
import org.openl.rules.tbasic.runtime.OpenLAlgorithmErrorSignal;
import org.openl.rules.tbasic.runtime.OpenLAlgorithmGoToMainSignal;
import org.openl.rules.tbasic.runtime.Result;
import org.openl.rules.tbasic.runtime.ReturnType;
import org.openl.rules.tbasic.runtime.TBasicContextHolderEnv;
import org.openl.rules.tbasic.runtime.TBasicVMDataContext;
import org.openl.rules.tbasic.runtime.operations.RuntimeOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TBasicVM {
    private TBasicVMDataContext mainContext;
    private TBasicVMDataContext currentContext;

    public TBasicVM(List<RuntimeOperation> operations, Map<String, RuntimeOperation> labels) {
        this.currentContext = this.mainContext = new TBasicVMDataContext(operations, labels, true);
    }

    private RuntimeOperation getLabeledOperation(String label) {
        if (this.currentContext.isLabelInContext(label)) {
            return this.currentContext.getLabeledOperation(label);
        }
        if (this.mainContext.isLabelInContext(label)) {
            this.goToLabelInMainContext(label);
        }
        throw new RuntimeException(String.format("Unexpected error while execution of TBasic component: unknown label \"%s\"", label));
    }

    private void goToLabelInMainContext(String label) {
        throw new OpenLAlgorithmGoToMainSignal(label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object run(List<RuntimeOperation> methodSteps, Map<String, RuntimeOperation> methodLabels, TBasicContextHolderEnv environment, boolean debugMode) {
        TBasicVMDataContext methodContext = new TBasicVMDataContext(methodSteps, methodLabels, false);
        TBasicVMDataContext previousContext = this.swapContext(methodContext);
        try {
            Object object = this.run(environment, debugMode);
            return object;
        }
        finally {
            this.swapContext(previousContext);
        }
    }

    public Object run(TBasicContextHolderEnv environment, boolean debugMode) {
        assert (environment != null);
        Object returnResult = null;
        try {
            returnResult = this.runAll(environment, debugMode);
        }
        catch (OpenLAlgorithmErrorSignal signal) {
            if (this.currentContext.isMainMethodContext()) {
                returnResult = AlgorithmErrorHelper.processError(signal.getCause(), environment);
            }
            throw signal;
        }
        catch (ControlSignal signal) {
            throw signal;
        }
        catch (Throwable error) {
            if (this.currentContext.isMainMethodContext()) {
                returnResult = AlgorithmErrorHelper.processError(error, environment);
            }
            throw new OpenLAlgorithmErrorSignal(error);
        }
        return returnResult;
    }

    private Object runAll(TBasicContextHolderEnv environment, boolean debugMode) {
        RuntimeOperation operation = this.currentContext.getFirstOperation();
        Object previousStepResult = null;
        Object returnResult = null;
        while (operation != null) {
            Result operationResult;
            try {
                operationResult = operation.execute(environment, previousStepResult, debugMode);
                assert (operationResult != null);
            }
            catch (OpenLAlgorithmGoToMainSignal signal) {
                operation = this.getLabeledOperation(signal.getLabel());
                continue;
            }
            if (operationResult.getReturnType() == ReturnType.GOTO) {
                assert (operationResult.getValue() instanceof String);
                operation = this.getLabeledOperation((String)operationResult.getValue());
                continue;
            }
            if (operationResult.getReturnType() == ReturnType.RETURN) {
                returnResult = operationResult.getValue();
                break;
            }
            operation = this.currentContext.getNextOperation(operation);
            previousStepResult = operationResult.getValue();
            if (previousStepResult == null) continue;
            returnResult = previousStepResult;
        }
        return returnResult;
    }

    private TBasicVMDataContext swapContext(TBasicVMDataContext newContext) {
        TBasicVMDataContext oldValue = this.currentContext;
        this.currentContext = newContext;
        return oldValue;
    }
}

